/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InefficientWeightDetector
extends LayoutDetector {
    public static final Issue INEFFICIENT_WEIGHT = Issue.create("InefficientWeight", "Looks for inefficient weight declarations in LinearLayouts", "When only a single widget in a LinearLayout defines a weight, it is more efficient to assign a width/height of 0dp to it since it will absorb all the remaining space anyway. With a declared width/height of 0dp it does not have to measure its own size first.", Category.PERFORMANCE, 3, Severity.WARNING, InefficientWeightDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue NESTED_WEIGHTS = Issue.create("NestedWeights", "Looks for nested layout weights, which are costly", "Layout weights require a widget to be measured twice. When a LinearLayout with non-zero weights is nested inside another LinearLayout with non-zero weights, then the number of measurements increase exponentially.", Category.PERFORMANCE, 3, Severity.WARNING, InefficientWeightDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue BASELINE_WEIGHTS = Issue.create("DisableBaselineAlignment", "Looks for LinearLayouts which should set android:baselineAligned=false", "When a LinearLayout is used to distribute the space proportionally between nested layouts, the baseline alignment property should be turned off to make the layout computation faster.", Category.PERFORMANCE, 3, Severity.WARNING, InefficientWeightDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private Map<Node, Boolean> mInsideWeight = new HashMap<Node, Boolean>();

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("LinearLayout");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        Object object;
        List<Element> list = LintUtils.getChildren(element);
        boolean bl = false;
        Element element2 = null;
        boolean bl2 = xmlContext.isEnabled(NESTED_WEIGHTS);
        Node node = element.getParentNode();
        for (Element object3 : list) {
            if (!object3.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) continue;
            if (element2 != null) {
                bl = true;
            } else if (!bl) {
                element2 = object3;
            }
            if (!bl2) continue;
            this.mInsideWeight.put(element, Boolean.TRUE);
            Boolean bl3 = this.mInsideWeight.get(node);
            if (bl3 == null) {
                this.mInsideWeight.put(node, Boolean.FALSE);
                continue;
            }
            if (!bl3.booleanValue()) continue;
            object = object3.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_weight");
            xmlContext.report(NESTED_WEIGHTS, (Node)object, xmlContext.getLocation((Node)object), "Nested weights are bad for performance", null);
            bl2 = false;
        }
        if (xmlContext.isEnabled(BASELINE_WEIGHTS) && element2 != null && !"vertical".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "baselineAligned")) {
            boolean bl3 = list.size() > 0;
            for (Element element3 : list) {
                if (element3.getTagName().endsWith("Layout")) continue;
                bl3 = false;
            }
            if (bl3) {
                xmlContext.report(BASELINE_WEIGHTS, element, xmlContext.getLocation(element), "Set android:baselineAligned=\"false\" on this element for better performance", null);
            }
        }
        if (xmlContext.isEnabled(INEFFICIENT_WEIGHT) && element2 != null && !bl) {
            String string;
            String string2 = "vertical".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation")) ? "layout_height" : "layout_width";
            Attr attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", string2);
            String string3 = string = attr != null ? attr.getValue() : "(undefined)";
            if (!string.startsWith("0")) {
                object = String.format("Use a %1$s of 0dip instead of %2$s for better performance", string2, string);
                xmlContext.report(INEFFICIENT_WEIGHT, element, xmlContext.getLocation(attr != null ? attr : element2), (String)object, null);
            }
        }
    }
}

