/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestOrderDetector
extends Detector
implements Detector.XmlScanner {
    public static final Issue ORDER = Issue.create("ManifestOrder", "Checks for manifest problems like <uses-sdk> after the <application> tag", "The <application> tag should appear after the elements which declare which version you need, which features you need, which libraries you need, and so on. In the past there have been subtle bugs (such as themes not getting applied correctly) when the <application> tag appears before some of these other elements, so it's best to order your manifest in the logical dependency order.", Category.CORRECTNESS, 5, Severity.WARNING, ManifestOrderDetector.class, EnumSet.of(Scope.MANIFEST));
    public static final Issue USES_SDK = Issue.create("UsesMinSdkAttributes", "Checks that the minimum SDK and target SDK attributes are defined", "The manifest should contain a <uses-sdk> element which defines the minimum minimum API Level required for the application to run, as well as the target version (the highest API level you have tested the version for.)", Category.CORRECTNESS, 2, Severity.WARNING, ManifestOrderDetector.class, EnumSet.of(Scope.MANIFEST)).setMoreInfo("http://developer.android.com/guide/topics/manifest/uses-sdk-element.html");
    public static final Issue MULTIPLE_USES_SDK = Issue.create("MultipleUsesSdk", "Checks that the <uses-sdk> element appears at most once", "The <uses-sdk> element should appear just once; the tools will *not* merge the contents of all the elements so if you split up the atttributes across multiple elements, only one of them will take effect. To fix this, just merge all the attributes from the various elements into a single <uses-sdk> element.", Category.CORRECTNESS, 6, Severity.ERROR, ManifestOrderDetector.class, EnumSet.of(Scope.MANIFEST)).setMoreInfo("http://developer.android.com/guide/topics/manifest/uses-sdk-element.html");
    private boolean mSeenApplication;
    private int mSeenUsesSdk;

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public void beforeCheckFile(Context context) {
        this.mSeenApplication = false;
        this.mSeenUsesSdk = 0;
    }

    @Override
    public void afterCheckFile(Context context) {
        if (this.mSeenUsesSdk == 0 && context.isEnabled(USES_SDK)) {
            context.report(USES_SDK, Location.create(context.file), "Manifest should specify a minimum API level with <uses-sdk android:minSdkVersion=\"?\" />; if it really supports all versions of Android set it to 1.", null);
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "uses-permission", "permission", "permission-tree", "permission-group", "uses-sdk", "uses-configuration", "uses-feature", "supports-screens", "compatible-screens", "supports-gl-texture");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        String string = element.getTagName();
        if (string.equals("uses-sdk")) {
            ++this.mSeenUsesSdk;
            if (this.mSeenUsesSdk == 2) {
                Location location = xmlContext.getLocation(element);
                NodeList nodeList = element.getOwnerDocument().getElementsByTagName("uses-sdk");
                Location location2 = null;
                for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                    Element element2 = (Element)nodeList.item(i);
                    if (element2 == element) continue;
                    Location location3 = xmlContext.getLocation(element2);
                    location3.setSecondary(location2);
                    location3.setMessage("Also appears here");
                    location2 = location3;
                }
                location.setSecondary(location2);
                if (xmlContext.isEnabled(MULTIPLE_USES_SDK)) {
                    xmlContext.report(MULTIPLE_USES_SDK, element, location, "There should only be a single <uses-sdk> element in the manifest: merge these together", null);
                }
                return;
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                if (xmlContext.isEnabled(USES_SDK)) {
                    xmlContext.report(USES_SDK, element, xmlContext.getLocation(element), "<uses-sdk> tag should specify a minimum API level with android:minSdkVersion=\"?\"", null);
                }
            } else if (xmlContext.getProject().getMinSdk() <= 9 && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion") && xmlContext.isEnabled(USES_SDK)) {
                xmlContext.report(USES_SDK, element, xmlContext.getLocation(element), "<uses-sdk> tag should specify a target API level (the highest verified version; when running on later versions, compatibility behaviors may be enabled) with android:targetSdkVersion=\"?\"", null);
            }
        }
        if (string.equals("application")) {
            this.mSeenApplication = true;
        } else if (this.mSeenApplication) {
            if (xmlContext.isEnabled(ORDER)) {
                xmlContext.report(ORDER, element, xmlContext.getLocation(element), String.format("<%1$s> tag appears after <application> tag", string), null);
            }
            this.mSeenApplication = false;
        }
    }
}

