/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceDetector
extends LayoutDetector {
    public static final Issue TYPO = Issue.create("NamespaceTypo", "Looks for misspellings in namespace declarations", "Accidental misspellings in namespace declarations can lead to some very obscure error messages. This check looks for potential misspellings to help track these down.", Category.CORRECTNESS, 8, Severity.WARNING, NamespaceDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue UNUSED = Issue.create("UnusedNamespace", "Finds unused namespaces in XML documents", "Unused namespace declarations take up space and require processing that is not necessary", Category.CORRECTNESS, 1, Severity.WARNING, NamespaceDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue CUSTOMVIEW = Issue.create("LibraryCustomView", "Flags custom attributes in libraries, which must use the res-auto-namespace instead", "When using a custom view with custom attributes in a library project, the layout must use the special namespace http://schemas.android.com/apk/res-auto instead of a URI which includes the library project's own package. This will be used to automatically adjust the namespace of the attributes when the library resources are merged into the application project.", Category.CORRECTNESS, 6, Severity.ERROR, NamespaceDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private static final String XMLNS_ANDROID = "xmlns:android";
    private static final String XMLNS_A = "xmlns:a";
    private Map<String, Attr> mUnusedNamespaces;
    private boolean mCheckUnused;
    private boolean mCheckCustomAttrs;

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(XmlContext xmlContext, Document document) {
        Object object;
        Object object2;
        boolean bl = false;
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            object2 = namedNodeMap.item(i);
            if (!object2.getNodeName().startsWith("xmlns:") || ((String)(object = object2.getNodeValue())).equals("http://schemas.android.com/apk/res/android")) continue;
            Attr attr = (Attr)object2;
            if (((String)object).startsWith("http://schemas.android.com/apk/res/")) {
                bl = true;
                if (this.mUnusedNamespaces == null) {
                    this.mUnusedNamespaces = new HashMap<String, Attr>();
                }
                this.mUnusedNamespaces.put(object2.getNodeName().substring("xmlns:".length()), attr);
            }
            if (!(string = attr.getName()).equals(XMLNS_ANDROID) && !string.equals(XMLNS_A) || !xmlContext.isEnabled(TYPO) || string.equals(XMLNS_A) && LintUtils.editDistance("http://schemas.android.com/apk/res/android", (String)object) > 4) continue;
            if (((String)object).equalsIgnoreCase("http://schemas.android.com/apk/res/android")) {
                xmlContext.report(TYPO, attr, xmlContext.getLocation(attr), String.format("URI is case sensitive: was \"%1$s\", expected \"%2$s\"", object, "http://schemas.android.com/apk/res/android"), null);
                continue;
            }
            xmlContext.report(TYPO, attr, xmlContext.getLocation(attr), String.format("Unexpected namespace URI bound to the \"android\" prefix, was %1$s, expected %2$s", object, "http://schemas.android.com/apk/res/android"), null);
        }
        if (bl) {
            this.mCheckCustomAttrs = xmlContext.isEnabled(CUSTOMVIEW) && xmlContext.getProject().isLibrary();
            this.mCheckUnused = xmlContext.isEnabled(UNUSED);
            this.checkElement(xmlContext, document.getDocumentElement());
            if (this.mCheckUnused && this.mUnusedNamespaces.size() > 0) {
                for (Map.Entry<String, Attr> entry : this.mUnusedNamespaces.entrySet()) {
                    object2 = entry.getKey();
                    object = entry.getValue();
                    xmlContext.report(UNUSED, (Node)object, xmlContext.getLocation((Node)object), String.format("Unused namespace %1$s", object2), null);
                }
            }
        }
    }

    private void checkElement(XmlContext xmlContext, Node node) {
        if (node.getNodeType() == 1) {
            Object object;
            int n;
            Object object2;
            if (this.mCheckCustomAttrs && ((String)(object2 = node.getNodeName())).indexOf(46) != -1 && !((String)object2).startsWith("android.")) {
                NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
                int n2 = namedNodeMap.getLength();
                for (n = 0; n < n2; ++n) {
                    object = (Attr)namedNodeMap.item(n);
                    String string = object.getNamespaceURI();
                    if (string == null || string.length() <= 0 || !string.startsWith("http://schemas.android.com/apk/res/") || string.equals("http://schemas.android.com/apk/res/android")) continue;
                    xmlContext.report(CUSTOMVIEW, (Node)object, xmlContext.getLocation((Node)object), "When using a custom namespace attribute in a library project, use the namespace \"http://schemas.android.com/apk/res-auto\" instead.", null);
                }
            }
            if (this.mCheckUnused) {
                object2 = ((Element)node).getAttributes();
                n = object2.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)object2.item(i);
                    object = attr.getPrefix();
                    if (object == null) continue;
                    this.mUnusedNamespaces.remove(object);
                }
            }
            object2 = node.getChildNodes();
            n = object2.getLength();
            for (int i = 0; i < n; ++i) {
                this.checkElement(xmlContext, object2.item(i));
            }
        }
    }
}

