/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedScrollingWidgetDetector
extends LayoutDetector {
    private int mVisitingHorizontalScroll;
    private int mVisitingVerticalScroll;
    public static final Issue ISSUE = Issue.create("NestedScrolling", "Checks whether a scrolling widget has any nested scrolling widgets within", "A scrolling widget such as a ScrollView should not contain any nested scrolling widgets since this has various usability issues", Category.CORRECTNESS, 7, Severity.WARNING, NestedScrollingWidgetDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public void beforeCheckFile(Context context) {
        this.mVisitingHorizontalScroll = 0;
        this.mVisitingVerticalScroll = 0;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ScrollView", "ListView", "GridView", "Gallery", "HorizontalScrollView");
    }

    private Element findOuterScrollingWidget(Node node, boolean bl) {
        Collection<String> collection = this.getApplicableElements();
        while (node != null) {
            Element element;
            String string;
            if (node instanceof Element && collection.contains(string = (element = (Element)node).getTagName()) && bl == this.isVerticalScroll(element)) {
                return element;
            }
            node = node.getParentNode();
        }
        return null;
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        Element element2;
        boolean bl = this.isVerticalScroll(element);
        if (bl) {
            ++this.mVisitingVerticalScroll;
        } else {
            ++this.mVisitingHorizontalScroll;
        }
        if ((this.mVisitingHorizontalScroll > 1 || this.mVisitingVerticalScroll > 1) && (element2 = this.findOuterScrollingWidget(element.getParentNode(), bl)) != null) {
            String string = this.mVisitingVerticalScroll > 1 ? "The vertically scrolling %1$s should not contain another vertically scrolling widget (%2$s)" : "The horizontally scrolling %1$s should not contain another horizontally scrolling widget (%2$s)";
            String string2 = String.format(string, element2.getTagName(), element.getTagName());
            xmlContext.report(ISSUE, element, xmlContext.getLocation(element), string2, null);
        }
    }

    @Override
    public void visitElementAfter(XmlContext xmlContext, Element element) {
        if (this.isVerticalScroll(element)) {
            --this.mVisitingVerticalScroll;
            assert (this.mVisitingVerticalScroll >= 0);
        } else {
            --this.mVisitingHorizontalScroll;
            assert (this.mVisitingHorizontalScroll >= 0);
        }
    }

    private boolean isVerticalScroll(Element element) {
        String string = element.getTagName();
        if (string.equals("Gallery") || string.equals("HorizontalScrollView")) {
            return false;
        }
        assert (string.equals("ScrollView") || string.equals("ListView") || string.equals("GridView"));
        return true;
    }
}

