/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.CompilationUnit;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.VariableReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverdrawDetector
extends LayoutDetector
implements Detector.JavaScanner {
    private static final String R_STYLE_PREFIX = "R.style.";
    private static final String SET_THEME = "setTheme";
    public static final Issue ISSUE = Issue.create("Overdraw", "Looks for overdraw issues (where a view is painted only to be fully painted over)", "If you set a background drawable on a root view, then you should use a custom theme where the theme background is null. Otherwise, the theme background will be painted first, only to have your custom background completely cover it; this is called \"overdraw\".\n\nNOTE: This detector relies on figuring out which layouts are associated with which activities based on scanning the Java code, and it's currently doing that using an inexact pattern matching algorithm. Therefore, it can incorrectly conclude which activity the layout is associated with and then wrongly complain that a background-theme is hidden.\n\nIf you want your custom background on multiple pages, then you should consider making a custom theme with your custom background and just using that theme instead of a root element background.\n\nOf course it's possible that your custom drawable is translucent and you want it to be mixed with the background. However, you will get better performance if you pre-mix the background with your drawable and use that resulting image or color as a custom theme background instead.\n", Category.PERFORMANCE, 3, Severity.WARNING, OverdrawDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE, Scope.ALL_RESOURCE_FILES));
    private Map<String, String> mActivityToTheme;
    private String mManifestTheme;
    private Map<String, List<String>> mLayoutToActivity;
    private List<String> mBlankThemes;
    private Set<String> mActivities;
    private List<String> mValidDrawables;
    private List<Pair<Location, String>> mRootAttributes;

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return super.appliesTo(resourceFolderType) || resourceFolderType == ResourceFolderType.VALUES || resourceFolderType == ResourceFolderType.DRAWABLE;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return LintUtils.isXmlFile(file) || LintUtils.endsWith(file.getName(), ".java");
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    private boolean isBlankTheme(String string) {
        if (string.startsWith("@android:style/Theme_") && (string.contains("NoFrame") || string.contains("Theme_Wallpaper") || string.contains("Theme_Holo_Wallpaper") || string.contains("Theme_Translucent") || string.contains("Theme_Dialog_NoFrame") || string.contains("Theme_Holo_Dialog_Alert") || string.contains("Theme_Holo_Light_Dialog_Alert") || string.contains("Theme_Dialog_Alert") || string.contains("Theme_Panel") || string.contains("Theme_Light_Panel") || string.contains("Theme_Holo_Panel") || string.contains("Theme_Holo_Light_Panel"))) {
            return true;
        }
        return this.mBlankThemes != null && this.mBlankThemes.contains(string);
    }

    @Override
    public void afterCheckProject(Context context) {
        if (this.mRootAttributes != null) {
            for (Pair<Location, String> pair : this.mRootAttributes) {
                String string;
                Location location = pair.getFirst();
                Object object = location.getClientData();
                if (object instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(ISSUE, (org.w3c.dom.Node)object)) {
                    return;
                }
                String string2 = location.getFile().getName();
                if (LintUtils.endsWith(string2, ".xml")) {
                    string2 = string2.substring(0, string2.length() - ".xml".length());
                }
                if ((string = this.getTheme(context, string2)) != null && this.isBlankTheme(string)) continue;
                String string3 = pair.getSecond();
                String string4 = String.format("Possible overdraw: Root element paints background %1$s with a theme that also paints a background (inferred theme is %2$s)", string3, string);
                context.report(ISSUE, location, string4, null);
            }
        }
    }

    private String getTheme(Context context, String string) {
        Object object;
        if (this.mActivityToTheme != null && this.mLayoutToActivity != null && (object = this.mLayoutToActivity.get(string)) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = this.mActivityToTheme.get(string2);
                if (string3 == null) continue;
                return string3;
            }
        }
        if (this.mManifestTheme != null) {
            return this.mManifestTheme;
        }
        object = context.getMainProject();
        int n = ((Project)object).getTargetSdk();
        if (n == -1) {
            n = ((Project)object).getMinSdk();
        }
        if (n >= 11) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        if (attr.getOwnerDocument().getDocumentElement() == attr.getOwnerElement()) {
            String string = attr.getValue();
            if (this.mValidDrawables != null && this.mValidDrawables.contains(string)) {
                return;
            }
            if (string.equals("@android:color/transparent")) {
                return;
            }
            if (string.startsWith("@android:drawable/")) {
                return;
            }
            String string2 = xmlContext.file.getName();
            if (string2.contains("list_") || string2.contains("_item")) {
                return;
            }
            Location location = xmlContext.getLocation(attr);
            location.setClientData(attr);
            if (this.mRootAttributes == null) {
                this.mRootAttributes = new ArrayList<Pair<Location, String>>();
            }
            this.mRootAttributes.add(Pair.of(location, attr.getValue()));
        }
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("background");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("activity", "application", "style", "bitmap");
    }

    @Override
    public void beforeCheckFile(Context context) {
        File file;
        ResourceFolderType resourceFolderType;
        if (LintUtils.endsWith(context.file.getName(), ".xml") && (resourceFolderType = ResourceFolderType.getFolderType((file = context.file.getParentFile()).getName())) == ResourceFolderType.DRAWABLE) {
            if (this.mValidDrawables == null) {
                this.mValidDrawables = new ArrayList<String>();
            }
            String string = this.getDrawableResource(context.file);
            this.mValidDrawables.add(string);
        }
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        String string = element.getTagName();
        if (string.equals("style")) {
            this.scanTheme(element);
        } else if (string.equals("activity")) {
            this.scanActivity(xmlContext, element);
        } else if (string.equals("application")) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "theme")) {
                this.mManifestTheme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
            }
        } else if (string.equals("bitmap")) {
            this.scanBitmap(xmlContext, element);
        }
    }

    private String getDrawableResource(File file) {
        String string = file.getName();
        if (LintUtils.endsWith(string, ".xml")) {
            string = string.substring(0, string.length() - ".xml".length());
        }
        return "@drawable/" + string;
    }

    private void scanBitmap(Context context, Element element) {
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "tileMode");
        if (!string.equals("disabled") && string.length() != 0 && this.mValidDrawables != null) {
            String string2 = this.getDrawableResource(context.file);
            this.mValidDrawables.remove(string2);
        }
    }

    private void scanActivity(Context context, Element element) {
        String string;
        String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string2.indexOf(36) != -1) {
            string2 = string2.replace('$', '.');
        }
        if (string2.startsWith(".") && (string = context.getProject().getPackage()) != null && string.length() > 0) {
            string2 = string + string2;
        }
        if (this.mActivities == null) {
            this.mActivities = new HashSet<String>();
        }
        this.mActivities.add(string2);
        string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
        if (string != null && string.length() > 0) {
            if (this.mActivityToTheme == null) {
                this.mActivityToTheme = new HashMap<String, String>();
            }
            this.mActivityToTheme.put(string2, string.replace('.', '_'));
        }
    }

    private void scanTheme(Element element) {
        int n;
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("parent");
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() == 0 && (n = string.lastIndexOf(46)) != -1) {
            string2 = string.substring(0, n);
        }
        string2 = string2.replace('.', '_');
        String string3 = "@style/" + string.replace('.', '_');
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Element element2;
            String string4;
            if (nodeList.item(i).getNodeType() != 1 || !(string4 = (element2 = (Element)nodeList.item(i)).getAttribute("name")).equals("android:windowBackground")) continue;
            NodeList nodeList2 = element2.getChildNodes();
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                String string5;
                String string6;
                org.w3c.dom.Node node = nodeList2.item(j);
                if (node.getNodeType() != 3 || (string6 = (string5 = node.getNodeValue()).trim()).length() <= 0 || !string6.equals("@null") && !string6.equals("@android:color/transparent") && (this.mValidDrawables == null || !this.mValidDrawables.contains(string6))) continue;
                if (this.mBlankThemes == null) {
                    this.mBlankThemes = new ArrayList<String>();
                }
                this.mBlankThemes.add(string3);
            }
            return;
        }
        if (this.isBlankTheme(string2)) {
            if (this.mBlankThemes == null) {
                this.mBlankThemes = new ArrayList<String>();
            }
            this.mBlankThemes.add(string3);
            return;
        }
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return null;
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext javaContext) {
        return new OverdrawVisitor();
    }

    private class OverdrawVisitor
    extends ForwardingAstVisitor {
        private static final String ACTIVITY = "Activity";
        private String mClassFqn;

        private OverdrawVisitor() {
        }

        public boolean visitClassDeclaration(ClassDeclaration classDeclaration) {
            String string = classDeclaration.getDescription();
            if (OverdrawDetector.this.mActivities != null && OverdrawDetector.this.mActivities.contains(this.mClassFqn) || string.endsWith(ACTIVITY) || classDeclaration.astExtending() != null && classDeclaration.astExtending().getDescription().endsWith(ACTIVITY)) {
                String string2 = "";
                if (classDeclaration.getParent() instanceof CompilationUnit) {
                    CompilationUnit compilationUnit = (CompilationUnit)classDeclaration.getParent();
                    string2 = compilationUnit.astPackageDeclaration().getPackageName();
                }
                this.mClassFqn = (string2.length() > 0 ? string2 + '.' : "") + string;
                return false;
            }
            return true;
        }

        public boolean visitSelect(Select select) {
            if (select.astIdentifier().astValue().equals("layout") && select.astOperand() instanceof VariableReference && ((VariableReference)select.astOperand()).astIdentifier().astValue().equals("R") && select.getParent() instanceof Select) {
                ArrayList<String> arrayList;
                String string = ((Select)select.getParent()).astIdentifier().astValue();
                if (OverdrawDetector.this.mLayoutToActivity == null) {
                    OverdrawDetector.this.mLayoutToActivity = new HashMap();
                }
                if ((arrayList = (ArrayList<String>)OverdrawDetector.this.mLayoutToActivity.get(string)) == null) {
                    arrayList = new ArrayList<String>();
                    OverdrawDetector.this.mLayoutToActivity.put(string, arrayList);
                }
                arrayList.add(this.mClassFqn);
            }
            return false;
        }

        public boolean visitMethodInvocation(MethodInvocation methodInvocation) {
            String string;
            Expression expression;
            StrictListAccessor strictListAccessor;
            if (methodInvocation.astName().astValue().equals(OverdrawDetector.SET_THEME) && (strictListAccessor = methodInvocation.astArguments()).size() == 1 && (expression = (Expression)strictListAccessor.first()) instanceof Select && (string = expression.toString()).startsWith(OverdrawDetector.R_STYLE_PREFIX)) {
                if (OverdrawDetector.this.mActivityToTheme == null) {
                    OverdrawDetector.this.mActivityToTheme = new HashMap();
                }
                String string2 = ((Select)expression).astIdentifier().astValue();
                OverdrawDetector.this.mActivityToTheme.put(this.mClassFqn, "@style/" + string2);
            }
            return false;
        }
    }
}

