/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.EnumSet;

public class ProguardDetector
extends Detector {
    public static final Issue WRONGKEEP = Issue.create("Proguard", "Looks for problems in proguard config files", "Using -keepclasseswithmembernames in a proguard config file is not correct; it can cause some symbols to be renamed which should not be.\nEarlier versions of ADT used to create proguard.cfg files with the wrong format. Instead of -keepclasseswithmembernames use -keepclasseswithmembers, since the old flags also implies \"allow shrinking\" which means symbols only referred to from XML and not Java (such as possibly CustomViews) can get deleted.", Category.CORRECTNESS, 8, Severity.FATAL, ProguardDetector.class, EnumSet.of(Scope.PROGUARD_FILE)).setMoreInfo("http://http://code.google.com/p/android/issues/detail?id=16384");
    public static final Issue SPLITCONFIG = Issue.create("ProguardSplit", "Checks for old proguard.cfg files that contain generic Android rules", "Earlier versions of the Android tools bundled a single \"proguard.cfg\" file containing a ProGuard configuration file suitable for Android shrinking and obfuscation. However, that version was copied into new projects, which means that it does not continue to get updated as we improve the default ProGuard rules for Android.\n\nIn the new version of the tools, we have split the ProGuard configuration into two halves:\n* A simple configuration file containing only project-specific flags, in your project\n* A generic configuration file containing the recommended set of ProGuard options for Android projects. This generic file lives in the SDK install directory which means that it gets updated along with the tools.\n\nIn order for this to work, the proguard.config property in the project.properties file now refers to a path, so you can reference both the generic file as well as your own (and any additional files too).\n\nTo migrate your project to the new setup, create a new proguard-project.txt file in your project containing any project specific ProGuard flags as well as any customizations you have made, then update your project.properties file to contain:\nproguard.config=${sdk.dir}/tools/proguard/proguard-android.txt:proguard-project.txt", Category.CORRECTNESS, 3, Severity.WARNING, ProguardDetector.class, EnumSet.of(Scope.PROGUARD_FILE));

    public void run(Context context) {
        String string = context.getContents();
        if (string != null) {
            int n;
            if (context.isEnabled(WRONGKEEP) && (n = string.indexOf("-keepclasseswithmembernames class * {\n    public <init>(android.")) != -1) {
                context.report(WRONGKEEP, Location.create(context.file, string, n, n), "Obsolete ProGuard file; use -keepclasseswithmembers instead of -keepclasseswithmembernames", null);
            }
            if (context.isEnabled(SPLITCONFIG) && (n = string.indexOf("-keep public class * extends android.app.Activity")) != -1) {
                File file = new File(context.file.getParentFile(), "project.properties");
                if (!file.exists()) {
                    return;
                }
                String string2 = context.getClient().readFile(file);
                int n2 = string2.indexOf("proguard.config");
                if (n2 == -1) {
                    return;
                }
                while (n2 >= 0) {
                    char c = string2.charAt(n2);
                    if (c == '#') {
                        return;
                    }
                    if (c == '\n') break;
                    --n2;
                }
                if (string2.contains("proguard.config")) {
                    context.report(SPLITCONFIG, Location.create(context.file, string, n, n), String.format("Local ProGuard configuration contains general Android configuration: Inherit these settings instead? Modify project.properties to define proguard.config=${sdk.dir}/tools/proguard/proguard-android.txt:%1$s and then keep only project-specific configuration here", context.file.getName()), null);
                }
            }
        }
    }

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }
}

