/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PxUsageDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("PxUsage", "Looks for use of the \"px\" dimension", "For performance reasons and to keep the code simpler, the Android system uses pixels as the standard unit for expressing dimension or coordinate values. That means that the dimensions of a view are always expressed in the code using pixels, but always based on the current screen density. For instance, if myView.getWidth() returns 10, the view is 10 pixels wide on the current screen, but on a device with a higher density screen, the value returned might be 15. If you use pixel values in your application code to work with bitmaps that are not pre-scaled for the current screen density, you might need to scale the pixel values that you use in your code to match the un-scaled bitmap source.", Category.CORRECTNESS, 2, Severity.WARNING, PxUsageDetector.class, Scope.RESOURCE_FILE_SCOPE).setMoreInfo("http://developer.android.com/guide/practices/screens_support.html#screen-independence");

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        String string = attr.getValue();
        if (string.endsWith("px") && string.matches("\\d+px")) {
            if (string.charAt(0) == '0') {
                return;
            }
            xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), "Avoid using \"px\" as units; use \"dp\" instead", null);
        }
    }
}

