/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationDetector
extends LayoutDetector
implements Detector.ClassScanner {
    private static final String ANDROID_APP_ACTIVITY = "android/app/Activity";
    private static final String ANDROID_APP_SERVICE = "android/app/Service";
    private static final String ANDROID_CONTENT_CONTENT_PROVIDER = "android/content/ContentProvider";
    private static final String ANDROID_CONTENT_BROADCAST_RECEIVER = "android/content/BroadcastReceiver";
    public static final Issue ISSUE = Issue.create("Registered", "Ensures that Activities, Services and Content Providers are registered in the manifest", "Activities, services and content providers should be registered in the AndroidManifext.xml file using <activity>, <service> and <provider> tags.\n\nIf your activity is simply a parent class intended to be subclassed by other \"real\" activities, make it an abstract class.", Category.CORRECTNESS, 6, Severity.WARNING, RegistrationDetector.class, EnumSet.of(Scope.MANIFEST, Scope.CLASS_FILE)).setMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    private Multimap<String, String> mManifestRegistrations;
    private static final String[] sTags = new String[]{"activity", "service", "receiver", "provider"};
    private static final String[] sClasses = new String[]{"android/app/Activity", "android/app/Service", "android/content/BroadcastReceiver", "android/content/ContentProvider"};

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return true;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList(sTags);
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        String string = RegistrationDetector.getFqcn(element);
        String string2 = element.getTagName();
        String string3 = RegistrationDetector.tagToClass(string2);
        if (string3 != null) {
            String string4 = ClassContext.getInternalName(string);
            if (this.mManifestRegistrations == null) {
                this.mManifestRegistrations = ArrayListMultimap.create(4, 8);
            }
            this.mManifestRegistrations.put(string3, string4);
        }
    }

    private static String getFqcn(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        Element element2 = element.getOwnerDocument().getDocumentElement();
        String string = element2.getAttribute("package");
        String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string2.startsWith(".")) {
            stringBuilder.append(string);
        } else if (string2.indexOf(46) == -1) {
            stringBuilder.append(string);
            stringBuilder.append('.');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Override
    public void checkClass(ClassContext classContext, ClassNode classNode) {
        if ((classNode.access & 0x400) != 0) {
            return;
        }
        String string = classNode.name;
        int n = string.lastIndexOf(36);
        if (n != -1 && n < string.length() - 1 && Character.isDigit(string.charAt(n + 1))) {
            return;
        }
        while (string != null) {
            for (String string2 : sClasses) {
                Collection<String> collection;
                if (!string.equals(string2)) continue;
                Collection<String> collection2 = collection = this.mManifestRegistrations != null ? this.mManifestRegistrations.get(string) : null;
                if (collection != null && collection.contains(classNode.name)) continue;
                this.report(classContext, classNode, string);
            }
            string = classContext.getDriver().getSuperClass(string);
        }
    }

    private void report(ClassContext classContext, ClassNode classNode, String string) {
        Object object;
        String string2 = RegistrationDetector.classToTag(string);
        String string3 = ClassContext.createSignature(classNode.name, null, null);
        String string4 = null;
        if (this.mManifestRegistrations != null) {
            object = this.mManifestRegistrations.entries();
            Iterator<Map.Entry<String, String>> iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (!entry.getValue().equals(classNode.name)) continue;
                string4 = entry.getKey();
                break;
            }
        }
        if (string4 != null) {
            object = classContext.getLocationForLine(-1, string3, null);
            classContext.report(ISSUE, (Location)object, String.format("%1$s is a <%2$s> but is registered in the manifest as a <%3$s>", string3, string2, RegistrationDetector.classToTag(string4)), null);
        } else if (!string2.equals("receiver")) {
            object = classContext.getLocationForLine(-1, string3, null);
            classContext.report(ISSUE, (Location)object, String.format("The <%1$s> %2$s is not registered in the manifest", string2, string3), null);
        }
    }

    private static final String tagToClass(String string) {
        int n = sTags.length;
        for (int i = 0; i < n; ++i) {
            if (!sTags[i].equals(string)) continue;
            return sClasses[i];
        }
        return null;
    }

    private static final String classToTag(String string) {
        int n = sClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!sClasses[i].equals(string)) continue;
            return sTags[i];
        }
        return null;
    }
}

