/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollViewChildDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("ScrollViewSize", "Checks that ScrollViews use wrap_content in scrolling dimension", "ScrollView children must set their layout_width or layout_height attributes to wrap_content rather than fill_parent or match_parent in the scrolling dimension", Category.CORRECTNESS, 7, Severity.WARNING, ScrollViewChildDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ScrollView", "HorizontalScrollView");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        List<Element> list = LintUtils.getChildren(element);
        boolean bl = "HorizontalScrollView".equals(element.getTagName());
        String string = bl ? "layout_width" : "layout_height";
        for (Element element2 : list) {
            String string2;
            Attr attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", string);
            String string3 = string2 = attr != null ? attr.getValue() : null;
            if (!"fill_parent".equals(string2) && !"match_parent".equals(string2)) continue;
            String string4 = String.format("This %1$s should use android:%2$s=\"wrap_content\"", element2.getTagName(), string);
            xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), string4, null);
        }
    }
}

