/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleCycleDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("StyleCycle", "Looks for cycles in style definitions", "There should be no cycles in style definitions as this can lead to runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, StyleCycleDetector.class, Scope.RESOURCE_FILE_SCOPE).setMoreInfo("http://developer.android.com/guide/topics/ui/themes.html#Inheritance");

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singleton("style");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        Attr attr = element.getAttributeNode("parent");
        if (attr != null) {
            String string;
            String string2 = attr.getValue();
            if (string2.endsWith(string = element.getAttribute("name")) && string2.equals("@style/" + string)) {
                xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), String.format("Style %1$s should not extend itself", string), null);
            } else if (string2.startsWith("@style/") && string2.startsWith(string, "@style/".length()) && string2.startsWith(".", "@style/".length() + string.length())) {
                xmlContext.report(ISSUE, xmlContext.getLocation(attr), String.format("Potential cycle: %1$s is the implied parent of %2$s and this defines the opposite", string, string2.substring("@style/".length())), null);
            }
        }
    }
}

