/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextViewDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("TextViewEdits", "Looks for TextViews being used for input", "Using a <TextView> to input text is generally an error, you should be using <EditText> instead.  EditText is a subclass of TextView, and some of the editing support is provided by TextView, so it's possible to set some input-related properties on a TextView. However, using a TextView along with input attributes is usually a cut & paste error. To input text you should be using <EditText>.\nThis check also checks subclasses of TextView, such as Button and CheckBox, since these have the same issue: they should not be used with editable attributes.", Category.CORRECTNESS, 7, Severity.WARNING, TextViewDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("TextView", "Button", "ToggleButton", "CheckBox", "RadioButton", "CheckedTextView", "Switch");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getLocalName();
            if (string == null) continue;
            boolean bl = false;
            switch (string.charAt(0)) {
                case 'a': {
                    bl = string.equals("autoText");
                    break;
                }
                case 'b': {
                    bl = string.equals("bufferType") && attr.getValue().equals("editable");
                    break;
                }
                case 'p': {
                    bl = string.equals("password") || string.equals("phoneNumber") || string.equals("privateImeOptions");
                    break;
                }
                case 'c': {
                    bl = string.equals("capitalize") || string.equals("cursorVisible");
                    break;
                }
                case 'd': {
                    bl = string.equals("digits");
                    break;
                }
                case 'e': {
                    if (string.equals("editable")) {
                        bl = attr.getValue().equals("true");
                        break;
                    }
                    bl = string.equals("editorExtras");
                    break;
                }
                case 'i': {
                    if (string.equals("inputType")) {
                        object = attr.getValue();
                        bl = !((String)object).isEmpty() && !((String)object).equals("none");
                        break;
                    }
                    bl = string.equals("inputType") || string.equals("imeOptions") || string.equals("imeActionLabel") || string.equals("imeActionId") || string.equals("inputMethod");
                    break;
                }
                case 'n': {
                    bl = string.equals("numeric");
                }
            }
            if (!bl || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) continue;
            object = xmlContext.getLocation(attr);
            String string2 = element.getTagName();
            String string3 = string2.equals("TextView") ? String.format("Attribute %1$s should not be used with <TextView>: Change element type to <EditText> ?", attr.getName()) : String.format("Attribute %1$s should not be used with <%2$s>: intended for editable text widgets", attr.getName(), string2);
            xmlContext.report(ISSUE, attr, (Location)object, string3, null);
        }
    }
}

