/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.Select;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedResourceDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("UnusedResources", "Looks for unused resources", "Unused resources make applications larger and slow down builds.", Category.PERFORMANCE, 3, Severity.WARNING, UnusedResourceDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES));
    public static final Issue ISSUE_IDS = Issue.create("UnusedIds", "Looks for unused id's", "This resource id definition appears not to be needed since it is not referenced from anywhere. Having id definitions, even if unused, is not necessarily a bad idea since they make working on layouts and menus easier, so there is not a strong reason to delete these.", Category.PERFORMANCE, 1, Severity.WARNING, UnusedResourceDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES)).setEnabledByDefault(false);
    private Set<String> mDeclarations;
    private Set<String> mReferences;
    private Map<String, Location> mUnused;

    @Override
    public void run(Context context) {
        assert (false);
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return true;
    }

    @Override
    public void beforeCheckProject(Context context) {
        if (context.getPhase() == 1) {
            this.mDeclarations = new HashSet<String>(300);
            this.mReferences = new HashSet<String>(300);
        }
    }

    @Override
    public void beforeCheckFile(Context context) {
        int n;
        String string;
        String string2;
        ResourceType resourceType;
        File file = context.file;
        String string3 = file.getName();
        if ((LintUtils.endsWith(string3, ".xml") || LintUtils.endsWith(string3, ".png") || LintUtils.endsWith(string3, ".jpg") || LintUtils.endsWith(string3, ".gif")) && (resourceType = ResourceType.getEnum(string2 = string.substring(0, (n = (string = file.getParentFile().getName()).indexOf(45)) == -1 ? string.length() : n))) != null && LintUtils.isFileBasedResourceType(resourceType)) {
            String string4 = string3.substring(0, string3.length() - ".xml".length());
            String string5 = "R." + string2 + '.' + string4;
            if (context.getPhase() == 1) {
                this.mDeclarations.add(string5);
            } else {
                assert (context.getPhase() == 2);
                if (this.mUnused.containsKey(string5)) {
                    this.recordLocation(string5, Location.create(file));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterCheckProject(Context context) {
        if (context.getPhase() == 1) {
            this.mDeclarations.removeAll(this.mReferences);
            Set<String> set = this.mDeclarations;
            this.mReferences = null;
            this.mDeclarations = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String location : set) {
                if (!location.startsWith("R.style") && !location.startsWith("R.attr")) continue;
                arrayList.add(location);
            }
            set.removeAll(arrayList);
            if (set.size() > 0 && !context.isEnabled(ISSUE_IDS)) {
                Iterator<String> string = new ArrayList();
                for (String string2 : set) {
                    if (!string2.startsWith("R.id.")) continue;
                    string.add(string2);
                }
                set.removeAll((Collection<?>)((Object)string));
            }
            if (set.size() > 0) {
                this.mUnused = new HashMap<String, Location>(set.size());
                for (String string : set) {
                    this.mUnused.put(string, null);
                }
                context.requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            if (this.mUnused.size() > 0) {
                Object object;
                String string;
                for (Map.Entry<String, Location> object22 : this.mUnused.entrySet()) {
                    int n;
                    ResourceType resourceType;
                    string = object22.getKey();
                    Location location = object22.getValue();
                    if (location != null || (resourceType = ResourceType.getEnum((String)(object = string.substring(2, n = string.indexOf(46, 2))))) == null || !LintUtils.isFileBasedResourceType(resourceType)) continue;
                    String string3 = string.substring(n + 1);
                    File file = new File(context.getProject().getDir(), "res");
                    File[] fileArray = file.listFiles();
                    if (fileArray == null) continue;
                    Arrays.sort(fileArray, new Comparator<File>(){

                        @Override
                        public int compare(File file, File file2) {
                            return file.getName().compareTo(file2.getName());
                        }
                    });
                    for (File file2 : fileArray) {
                        File[] fileArray2;
                        if (!file2.getName().startsWith((String)object) || (fileArray2 = file2.listFiles()) == null) continue;
                        for (File file3 : fileArray2) {
                            String string4 = file3.getName();
                            if (!string4.startsWith(string3) || !string4.startsWith(".", string3.length())) continue;
                            this.recordLocation(string, Location.create(file3));
                        }
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>(this.mUnused.keySet());
                Collections.sort(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    void var5_18;
                    string = (String)iterator.next();
                    Location location = this.mUnused.get(string);
                    if (location != null) {
                        Location location2 = Location.reverse(location);
                    }
                    String string5 = String.format("The resource %1$s appears to be unused", string);
                    object = UnusedResourceDetector.getIssue(string);
                    context.report((Issue)object, (Location)var5_18, string5, string);
                }
            }
        }
    }

    private static Issue getIssue(String string) {
        return string.startsWith("R.id.") ? ISSUE_IDS : ISSUE;
    }

    private void recordLocation(String string, Location location) {
        Location location2 = this.mUnused.get(string);
        if (location2 != null) {
            location.setSecondary(location2);
        }
        this.mUnused.put(string, location);
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        block13: {
            block12: {
                if (!"resources".equals(element.getTagName())) break block12;
                for (Element element2 : LintUtils.getChildren(element)) {
                    String string;
                    String string2 = element2.getAttribute("name");
                    if (string2.length() <= 0) continue;
                    if (string2.indexOf(46) != -1) {
                        string2 = string2.replace('.', '_');
                    }
                    if ((string = element2.getTagName()).equals("item")) {
                        string = "id";
                    } else if (string.equals("declare-styleable")) {
                        string = "styleable";
                    } else if (string.contains("array")) {
                        string = "array";
                    }
                    String string3 = "R." + string + '.' + string2;
                    if (xmlContext.getPhase() == 1) {
                        this.mDeclarations.add(string3);
                        this.checkChildRefs(element2);
                        continue;
                    }
                    assert (xmlContext.getPhase() == 2);
                    if (!this.mUnused.containsKey(string3)) continue;
                    if (xmlContext.getDriver().isSuppressed(UnusedResourceDetector.getIssue(string3), element2)) {
                        this.mUnused.remove(string3);
                        return;
                    }
                    this.recordLocation(string3, xmlContext.getLocation(element2));
                }
                break block13;
            }
            if (this.mReferences == null) break block13;
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element element3 : LintUtils.getChildren(element)) {
                this.checkChildRefs(element3);
            }
        }
    }

    private void checkChildRefs(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            org.w3c.dom.Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            String string2 = node.getNodeValue();
            int n2 = string2.indexOf("?attr/");
            if (n2 != -1) {
                string = string2.substring(n2 + "?attr/".length()).trim();
                this.mReferences.add("R.attr." + string);
                continue;
            }
            n2 = string2.indexOf(64);
            if (n2 == -1 || string2.indexOf(47, n2) == -1 || string2.startsWith("@android:", n2)) continue;
            string = string2.substring(n2 + 1).trim().replace('/', '.');
            String string3 = "R." + string;
            this.mReferences.add(string3);
        }
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        String string = attr.getValue();
        if (string.startsWith("@+") && !string.startsWith("@+android")) {
            String string2 = "R." + string.substring(2).replace('/', '.');
            if (xmlContext.getPhase() == 1) {
                this.mDeclarations.add(string2);
            } else if (this.mUnused.containsKey(string2)) {
                if (xmlContext.getDriver().isSuppressed(UnusedResourceDetector.getIssue(string2), attr)) {
                    this.mUnused.remove(string2);
                    return;
                }
                this.recordLocation(string2, xmlContext.getLocation(attr));
                return;
            }
        } else if (this.mReferences != null) {
            if (string.startsWith("@") && !string.startsWith("@android:")) {
                String string3 = "R." + string.substring(1).replace('/', '.');
                this.mReferences.add(string3);
            } else if (string.startsWith("?attr/")) {
                this.mReferences.add("R.attr." + string.substring("?attr/".length()));
            }
        }
        if (attr.getNamespaceURI() != null && !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) && this.mReferences != null) {
            this.mReferences.add("R.attr." + attr.getLocalName());
        }
    }

    @Override
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(ClassDeclaration.class);
    }

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(JavaContext javaContext, AstVisitor astVisitor, VariableReference variableReference, String string, String string2, boolean bl) {
        if (this.mReferences != null && !bl) {
            String string3 = "R." + string + '.' + string2;
            this.mReferences.add(string3);
        }
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext javaContext) {
        if (this.mReferences != null) {
            return new UnusedResourceVisitor();
        }
        return null;
    }

    private class UnusedResourceVisitor
    extends ForwardingAstVisitor {
        private UnusedResourceVisitor() {
        }

        public boolean visitVariableReference(VariableReference variableReference) {
            if (variableReference.astIdentifier().getDescription().equals("R") && variableReference.getParent() instanceof Select && variableReference.getParent().getParent() instanceof Select) {
                String string = variableReference.getParent().getParent().toString();
                UnusedResourceDetector.this.mReferences.add(string);
            }
            return false;
        }

        public boolean visitClassDeclaration(ClassDeclaration classDeclaration) {
            String string = classDeclaration.getDescription();
            if (string.equals("R")) {
                for (Node node : classDeclaration.getChildren()) {
                    if (!(node instanceof NormalTypeBody)) continue;
                    for (Node node2 : node.getChildren()) {
                        if (!(node2 instanceof ClassDeclaration)) continue;
                        String string2 = ((ClassDeclaration)node2).getDescription();
                        for (Node node3 : node2.getChildren()) {
                            if (!(node3 instanceof NormalTypeBody)) continue;
                            for (Node node4 : node3.getChildren()) {
                                if (!(node4 instanceof VariableDeclaration)) continue;
                                for (Node node5 : node4.getChildren()) {
                                    if (!(node5 instanceof VariableDefinition)) continue;
                                    VariableDefinition variableDefinition = (VariableDefinition)node5;
                                    String string3 = ((VariableDefinitionEntry)variableDefinition.astVariables().first()).astName().astValue();
                                    String string4 = "R." + string2 + '.' + string3;
                                    UnusedResourceDetector.this.mDeclarations.add(string4);
                                }
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

