/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.ImportDeclaration;
import lombok.ast.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongImportDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("SuspiciousImport", "Checks for 'import android.R' statements, which are usually accidental", "Importing android.R is usually not intentional; it sometimes happens when you use an IDE and ask it to automatically add imports at a time when your project's R class it not present.\n\nOnce the import is there you might get a lot of \"confusing\" error messages because of course the fields available on android.R are not the ones you'd expect from just looking at your own R class.", Category.CORRECTNESS, 9, Severity.WARNING, WrongImportDetector.class, Scope.JAVA_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(ImportDeclaration.class);
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext javaContext) {
        return new ImportVisitor(javaContext);
    }

    private static class ImportVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public ImportVisitor(JavaContext javaContext) {
            this.mContext = javaContext;
        }

        public boolean visitImportDeclaration(ImportDeclaration importDeclaration) {
            String string = importDeclaration.asFullyQualifiedName();
            if (string.equals("android.R")) {
                Location location = this.mContext.getLocation((Node)importDeclaration);
                this.mContext.report(ISSUE, (Node)importDeclaration, location, "Don't include android.R here; use a fully qualified name for each usage instead", null);
            }
            return false;
        }
    }
}

