/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.AndroidDigestFactoryInterface;

public final class AndroidDigestFactory {
    private static final String OpenSSLFactoryClassName;
    private static final String BouncyCastleFactoryClassName;
    private static final AndroidDigestFactoryInterface FACTORY;

    public static Digest getMD5() {
        return FACTORY.getMD5();
    }

    public static Digest getSHA1() {
        return FACTORY.getSHA1();
    }

    public static Digest getSHA256() {
        return FACTORY.getSHA256();
    }

    public static Digest getSHA384() {
        return FACTORY.getSHA384();
    }

    public static Digest getSHA512() {
        return FACTORY.getSHA512();
    }

    static {
        Class<?> clazz;
        OpenSSLFactoryClassName = AndroidDigestFactory.class.getName() + "OpenSSL";
        BouncyCastleFactoryClassName = AndroidDigestFactory.class.getName() + "BouncyCastle";
        try {
            clazz = Class.forName(OpenSSLFactoryClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(BouncyCastleFactoryClassName);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new AssertionError((Object)("Failed to find AndroidDigestFactoryInterface implementation. Looked for " + OpenSSLFactoryClassName + " and " + BouncyCastleFactoryClassName));
            }
        }
        if (!AndroidDigestFactoryInterface.class.isAssignableFrom(clazz)) {
            throw new AssertionError((Object)(clazz + "does not implement AndroidDigestFactoryInterface"));
        }
        try {
            FACTORY = (AndroidDigestFactoryInterface)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }
}

