/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Switch
extends AbstractNode
implements Statement {
    private AbstractNode condition = null;
    private AbstractNode body = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astCondition() {
        if (!(this.condition instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.condition);
    }

    public Switch astCondition(Expression condition) {
        if (condition == null) {
            throw new NullPointerException("condition is mandatory");
        }
        return this.rawCondition(condition);
    }

    public Node rawCondition() {
        return this.condition;
    }

    public Switch rawCondition(Node condition) {
        if (condition == this.condition) {
            return this;
        }
        if (condition != null) {
            this.adopt((AbstractNode)condition);
        }
        if (this.condition != null) {
            this.disown(this.condition);
        }
        this.condition = (AbstractNode)condition;
        return this;
    }

    public Block astBody() {
        if (!(this.body instanceof Block)) {
            return null;
        }
        return (Block)this.body;
    }

    public Switch astBody(Block body) {
        if (body == null) {
            throw new NullPointerException("body is mandatory");
        }
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public Switch rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.condition != null) {
            result.add(this.condition);
        }
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.condition == original) {
            this.rawCondition(replacement);
            return true;
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.condition == child) {
            this.disown((AbstractNode)child);
            this.condition = null;
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitSwitch(this)) {
            return;
        }
        if (this.condition != null) {
            this.condition.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Switch copy() {
        Switch result = new Switch();
        if (this.condition != null) {
            result.rawCondition(this.condition.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }
}

