/*************************************************************************/ /*!
@File           sgx_ukernel_status_codes.h
@Title          SGX microkernel debug status codes
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@Description    SGX microkernel debug status codes
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ /**************************************************************************/

#ifndef __SGX_UKERNEL_STATUS_CODES_H__
#define __SGX_UKERNEL_STATUS_CODES_H__

/*
	NOTE: Do not add any conditional macros to this file! There must be
	no use of #if defined(). This file is included in srvkm to print
	stringified ukernel status codes, it must build identically to
	srvinit.
*/

/*
	Users of this header might define this macro to do something
	clever; the primary use right now is to generate a switch/case
	LUT for debugging in srvkm. If you add a new code, make sure it
	has a corresponding MKTC_ST.
*/
#ifndef MKTC_ST
#define MKTC_ST(x)
#endif

/*
	It would be nice to put these definitions into an enumeration, but USEASM
	only has access to the C preprocessor so macros are required.
*/

/*
	Bits 24-31 of these codes (0xAD) are a magic number used to help
	distinguish between them and other debug information which can be
	optionally dumped into the status buffer, e.g. sync object values.
*/

/*
	Microkernel trace codes
*/
#define MKTC_EHEVENT_3DMEMFREE					0xAD000001
MKTC_ST(MKTC_EHEVENT_3DMEMFREE)
#define MKTC_EHEVENT_PIXELENDRENDER				0xAD000002
MKTC_ST(MKTC_EHEVENT_PIXELENDRENDER)
#define MKTC_EHEVENT_ISPBREAKPOINT				0xAD000004
MKTC_ST(MKTC_EHEVENT_ISPBREAKPOINT)
#define MKTC_EHEVENT_TAFINISHED					0xAD000005
MKTC_ST(MKTC_EHEVENT_TAFINISHED)
#define MKTC_EHEVENT_OUTOFMEM					0xAD000007
MKTC_ST(MKTC_EHEVENT_OUTOFMEM)
#define MKTC_EHEVENT_TATERMINATE				0xAD000008
MKTC_ST(MKTC_EHEVENT_TATERMINATE)
#define MKTC_EHEVENT_TIMER						0xAD000009
MKTC_ST(MKTC_EHEVENT_TIMER)
#define MKTC_EHEVENT_SWEVENT					0xAD00000A
MKTC_ST(MKTC_EHEVENT_SWEVENT)
#define MKTC_EHEVENT_2DCOMPLETE					0xAD00000B
MKTC_ST(MKTC_EHEVENT_2DCOMPLETE)

#define MKTC_3DEVENT_3DMEMFREE					0xAD000100
MKTC_ST(MKTC_3DEVENT_3DMEMFREE)
#define MKTC_3DEVENT_PIXELENDRENDER				0xAD000101
MKTC_ST(MKTC_3DEVENT_PIXELENDRENDER)
#define MKTC_3DEVENT_ISPBREAKPOINT				0xAD000102
MKTC_ST(MKTC_3DEVENT_ISPBREAKPOINT)
#define MKTC_3DEVENT_END						0xAD000104
MKTC_ST(MKTC_3DEVENT_END)
#define MKTC_3DLB_3DMEMFREE						0xAD000180
MKTC_ST(MKTC_3DLB_3DMEMFREE)
#define MKTC_3DLB_PIXELENDRENDER				0xAD000181
MKTC_ST(MKTC_3DLB_PIXELENDRENDER)
#define MKTC_3DLB_ISPBREAKPOINT					0xAD000182
MKTC_ST(MKTC_3DLB_ISPBREAKPOINT)
#define MKTC_3DLB_FIND3D						0xAD000183
MKTC_ST(MKTC_3DLB_FIND3D)
#define MKTC_3DLB_END							0xAD000184
MKTC_ST(MKTC_3DLB_END)

#define MKTC_TAEVENT_TAFINISHED					0xAD000200
MKTC_ST(MKTC_TAEVENT_TAFINISHED)
#define MKTC_TAEVENT_END						0xAD000202
MKTC_ST(MKTC_TAEVENT_END)
#define MKTC_TALB_TAFINISHED					0xAD000280
MKTC_ST(MKTC_TALB_TAFINISHED)
#define MKTC_TALB_FINDTA						0xAD000281
MKTC_ST(MKTC_TALB_FINDTA)
#define MKTC_TALB_END							0xAD000282
MKTC_ST(MKTC_TALB_END)

#define MKTC_CRRL_WRITEOPSBLOCKED				0xAD000300
MKTC_ST(MKTC_CRRL_WRITEOPSBLOCKED)
#define MKTC_CRRL_READOPSBLOCKED				0xAD000301
MKTC_ST(MKTC_CRRL_READOPSBLOCKED)
#define MKTC_CRRL_FOUNDRENDER					0xAD000302
MKTC_ST(MKTC_CRRL_FOUNDRENDER)
#define MKTC_CRRL_NORENDER						0xAD000303
MKTC_ST(MKTC_CRRL_NORENDER)
#define MKTC_CRRL_TARC_DIFFERENT				0xAD000304
MKTC_ST(MKTC_CRRL_TARC_DIFFERENT)
#define MKTC_CRRL_BLOCKEDRC						0xAD000309
MKTC_ST(MKTC_CRRL_BLOCKEDRC)
#define MKTC_CRRL_BLOCKEDRTDATA					0xAD00030A
MKTC_ST(MKTC_CRRL_BLOCKEDRTDATA)
#define MKTC_CRRL_CONTEXT_SUSPENDED				0xAD00030B
MKTC_ST(MKTC_CRRL_CONTEXT_SUSPENDED)
#define MKTC_CRRL_TAWAITINGFORMEM				0xAD00030C
MKTC_ST(MKTC_CRRL_TAWAITINGFORMEM)
#define MKTC_CRRL_TAOOMBUTPRIOINV				0xAD00030D
MKTC_ST(MKTC_CRRL_TAOOMBUTPRIOINV)
#define MKTC_CRRL_READOPS2BLOCKED				0xAD00030E
MKTC_ST(MKTC_CRRL_READOPS2BLOCKED)
#define MKTC_CRRL_SRC_WRITEOPSBLOCKED			0xAD00030F
MKTC_ST(MKTC_CRRL_SRC_WRITEOPSBLOCKED)
#define MKTC_CRRL_SRC_READOPSBLOCKED			0xAD000310
MKTC_ST(MKTC_CRRL_SRC_READOPSBLOCKED)
#define MKTC_CRRL_TQ_WRITEOPSBLOCKED			0xAD000311
MKTC_ST(MKTC_CRRL_TQ_WRITEOPSBLOCKED)
#define MKTC_CRRL_TQ_READOPSBLOCKED				0xAD000312
MKTC_ST(MKTC_CRRL_TQ_READOPSBLOCKED)

#define MKTC_KICKRENDER_START					0xAD000400
MKTC_ST(MKTC_KICKRENDER_START)
#define MKTC_KICKRENDER_OVERLAP					0xAD000401
MKTC_ST(MKTC_KICKRENDER_OVERLAP)
#define MKTC_KICKRENDER_ISP_START				0xAD000402
MKTC_ST(MKTC_KICKRENDER_ISP_START)
#define MKTC_KICKRENDER_RESUME					0xAD000403
MKTC_ST(MKTC_KICKRENDER_RESUME)
#define MKTC_KICKRENDER_CONFIG_REGION_HDRS		0xAD000404
MKTC_ST(MKTC_KICKRENDER_CONFIG_REGION_HDRS)
#define MKTC_KICKRENDER_END						0xAD000408
MKTC_ST(MKTC_KICKRENDER_END)
#define MKTC_KICKRENDER_RENDERCONTEXT			0xAD000409
MKTC_ST(MKTC_KICKRENDER_RENDERCONTEXT)
#define MKTC_KICKRENDER_RTDATA					0xAD00040A
MKTC_ST(MKTC_KICKRENDER_RTDATA)
#define MKTC_KICKRENDER_PID						0xAD00040B
MKTC_ST(MKTC_KICKRENDER_PID)

#define MKTC_RENDERFINISHED_START				0xAD000500
MKTC_ST(MKTC_RENDERFINISHED_START)
#define MKTC_RF_START_NEXT_MT					0xAD000501
MKTC_ST(MKTC_RF_START_NEXT_MT)
#define MKTC_RF_ALL_MTS_DONE					0xAD000502
MKTC_ST(MKTC_RF_ALL_MTS_DONE)
#define MKTC_RENDERFINISHED_END					0xAD000503
MKTC_ST(MKTC_RENDERFINISHED_END)
#define MKTC_VISQUERY_START						0xAD000504
MKTC_ST(MKTC_VISQUERY_START)
#define MKTC_VISQUERY_END						0xAD000505
MKTC_ST(MKTC_VISQUERY_END)
#define MKTC_TRANSFERRENDERFINISHED_START		0xAD000508
MKTC_ST(MKTC_TRANSFERRENDERFINISHED_START)
#define MKTC_TRANSFERRENDERFINISHED_END			0xAD000509
MKTC_ST(MKTC_TRANSFERRENDERFINISHED_END)
#define MKTC_TRF_UPDATESTATUSVALS				0xAD00050A
MKTC_ST(MKTC_TRF_UPDATESTATUSVALS)
#define MKTC_TRF_UPDATESTATUSVALS_DONE			0xAD00050B
MKTC_ST(MKTC_TRF_UPDATESTATUSVALS_DONE)

#define MKTC_PIXELENDRENDER_START				0xAD000600
MKTC_ST(MKTC_PIXELENDRENDER_START)
#define MKTC_PIXELENDRENDER_AFTERLOCK			0xAD000601
MKTC_ST(MKTC_PIXELENDRENDER_AFTERLOCK)
#define MKTC_PIXELENDRENDER_END					0xAD000602
MKTC_ST(MKTC_PIXELENDRENDER_END)
#define MKTC_PIXELENDRENDER_TLQEND				0xAD000603
MKTC_ST(MKTC_PIXELENDRENDER_TLQEND)

#define MKTC_3DMEMFREE_START					0xAD000700
MKTC_ST(MKTC_3DMEMFREE_START)
#define MKTC_3DMEMFREE_AFTERLOCK				0xAD000701
MKTC_ST(MKTC_3DMEMFREE_AFTERLOCK)
#define MKTC_3DMEMFREE_TESTEOR					0xAD000702
MKTC_ST(MKTC_3DMEMFREE_TESTEOR)
#define MKTC_3DMEMFREE_END						0xAD000703
MKTC_ST(MKTC_3DMEMFREE_END)

#define MKTC_KICKTA_START						0xAD000800
MKTC_ST(MKTC_KICKTA_START)
#define MKTC_KICKTA_OVERLAP						0xAD000801
MKTC_ST(MKTC_KICKTA_OVERLAP)
#define MKTC_KICKTA_RESETCONTEXT				0xAD000802
MKTC_ST(MKTC_KICKTA_RESETCONTEXT)
#define MKTC_KICKTA_VDM_START					0xAD000803
MKTC_ST(MKTC_KICKTA_VDM_START)
#define MKTC_KICKTA_END							0xAD000804
MKTC_ST(MKTC_KICKTA_END)
#define MKTC_KICKTA_RENDERCONTEXT				0xAD000805
MKTC_ST(MKTC_KICKTA_RENDERCONTEXT)
#define MKTC_KICKTA_RTDATA						0xAD000806
MKTC_ST(MKTC_KICKTA_RTDATA)
#define MKTC_KICKTA_RESET_VDMCSSTATUS			0xAD000807
MKTC_ST(MKTC_KICKTA_RESET_VDMCSSTATUS)
#define MKTC_KICKTA_RESET_BUFFERS				0xAD000808
MKTC_ST(MKTC_KICKTA_RESET_BUFFERS)
#define MKTC_KICKTA_PID							0xAD000809
MKTC_ST(MKTC_KICKTA_PID)
#define MKTC_KICKTA_TACMD_DEBUG					0xAD00080A
MKTC_ST(MKTC_KICKTA_TACMD_DEBUG)
#define MKTC_KICKTA_FREECONTEXT					0xAD00080B
MKTC_ST(MKTC_KICKTA_FREECONTEXT)
#define MKTC_KICKTA_PIM_PATCHING				0xAD00080C
MKTC_ST(MKTC_KICKTA_PIM_PATCHING)

#define MKTC_KICKTA_CHKPT_START_DUMMY_CS		0xAD0008A1
MKTC_ST(MKTC_KICKTA_CHKPT_START_DUMMY_CS)
#define MKTC_KICKTA_CHKPT_START_DUMMY_TAK		0xAD0008A2
MKTC_ST(MKTC_KICKTA_CHKPT_START_DUMMY_TAK)
#define MKTC_KICKTA_CHKPT_WAIT_FOR_DUMMY_KICK	0xAD0008A3
MKTC_ST(MKTC_KICKTA_CHKPT_WAIT_FOR_DUMMY_KICK)
#define MKTC_KICKTA_CHKPT_WAIT_NEXT_CORE		0xAD0008A4
MKTC_ST(MKTC_KICKTA_CHKPT_WAIT_NEXT_CORE)
#define MKTC_KICKTA_CHKPT_RESET_COMPLETE		0xAD0008A5
MKTC_ST(MKTC_KICKTA_CHKPT_RESET_COMPLETE)
#define MKTC_KICKTA_CHKPT_CHECK_SWITCH			0xAD0008A6
MKTC_ST(MKTC_KICKTA_CHKPT_CHECK_SWITCH)

#define MKTC_HOSTKICK_START						0xAD000900
MKTC_ST(MKTC_HOSTKICK_START)
#define MKTC_HOSTKICK_END						0xAD000901
MKTC_ST(MKTC_HOSTKICK_END)
#define MKTC_HOSTKICK_PROCESS_QUEUES_END		0xAD000902
MKTC_ST(MKTC_HOSTKICK_PROCESS_QUEUES_END)
#define MKTC_HOSTKICK_2D						0xAD000903
MKTC_ST(MKTC_HOSTKICK_2D)
#define MKTC_HOSTKICK_TRANSFER					0xAD000904
MKTC_ST(MKTC_HOSTKICK_TRANSFER)
#define MKTC_HOSTKICK_TA						0xAD000905
MKTC_ST(MKTC_HOSTKICK_TA)
#define MKTC_HOSTKICK_PROCESS_QUEUES			0xAD000906
MKTC_ST(MKTC_HOSTKICK_PROCESS_QUEUES)
#define MKTC_HOSTKICK_RESUME					0xAD000908
MKTC_ST(MKTC_HOSTKICK_RESUME)
#define MKTC_HOSTKICK_POWEROFF					0xAD000909
MKTC_ST(MKTC_HOSTKICK_POWEROFF)
#define MKTC_HOSTKICK_IDLE						0xAD00090A
MKTC_ST(MKTC_HOSTKICK_IDLE)
#define MKTC_HOSTKICK_CTXSUSPEND				0xAD00090B
MKTC_ST(MKTC_HOSTKICK_CTXSUSPEND)
#define MKTC_HOSTKICK_CTXRESUME					0xAD00090C
MKTC_ST(MKTC_HOSTKICK_CTXRESUME)

#define MKTC_TIMER_POTENTIAL_TA_LOCKUP			0xAD000A00
MKTC_ST(MKTC_TIMER_POTENTIAL_TA_LOCKUP)
#define MKTC_TIMER_POTENTIAL_3D_LOCKUP			0xAD000A01
MKTC_ST(MKTC_TIMER_POTENTIAL_3D_LOCKUP)
#define MKTC_TIMER_CTAL_START					0xAD000A02
MKTC_ST(MKTC_TIMER_CTAL_START)
#define MKTC_TIMER_CTAL_END						0xAD000A03
MKTC_ST(MKTC_TIMER_CTAL_END)
#define MKTC_TIMER_C3DL_START					0xAD000A04
MKTC_ST(MKTC_TIMER_C3DL_START)
#define MKTC_TIMER_C3DL_END						0xAD000A05
MKTC_ST(MKTC_TIMER_C3DL_END)
#define MKTC_TIMER_LOCKUP						0xAD000A0A
MKTC_ST(MKTC_TIMER_LOCKUP)
#define MKTC_TIMER_NOT_TA_LOCKUP				0xAD000A0B
MKTC_ST(MKTC_TIMER_NOT_TA_LOCKUP)
#define MKTC_TIMER_NOT_3D_LOCKUP				0xAD000A0C
MKTC_ST(MKTC_TIMER_NOT_3D_LOCKUP)
#define MKTC_TIMER_2D_LOCKUP					0xAD000A0D
MKTC_ST(MKTC_TIMER_2D_LOCKUP)
#define MKTC_TIMER_POTENTIAL_2D_LOCKUP			0xAD000A10
MKTC_ST(MKTC_TIMER_POTENTIAL_2D_LOCKUP)
#define MKTC_TIMER_C2DL_START					0xAD000A11
MKTC_ST(MKTC_TIMER_C2DL_START)
#define MKTC_TIMER_C2DL_END						0xAD000A12
MKTC_ST(MKTC_TIMER_C2DL_END)
#define MKTC_TIMER_NOT_2D_LOCKUP				0xAD000A13
MKTC_ST(MKTC_TIMER_NOT_2D_LOCKUP)
#define MKTC_TIMER_ABORTALL						0xAD000A0E
MKTC_ST(MKTC_TIMER_ABORTALL)
#define MKTC_TIMER_END							0xAD000A0F
MKTC_ST(MKTC_TIMER_END)

#define MKTC_HWR_START							0xAD000B00
MKTC_ST(MKTC_HWR_START)
#define MKTC_HWR_END							0xAD000B01
MKTC_ST(MKTC_HWR_END)
#define MKTC_HWR_HKS							0xAD000B02
MKTC_ST(MKTC_HWR_HKS)
#define MKTC_HWR_PRL							0xAD000B03
MKTC_ST(MKTC_HWR_PRL)
#define MKTC_HWR_PRL_DP							0xAD000B04
MKTC_ST(MKTC_HWR_PRL_DP)
#define MKTC_HWR_CRL							0xAD000B05
MKTC_ST(MKTC_HWR_CRL)
#define MKTC_HWR_CRL_DP							0xAD000B06
MKTC_ST(MKTC_HWR_CRL_DP)
#define MKTC_HWR_TRL							0xAD000B07
MKTC_ST(MKTC_HWR_TRL)
#define MKTC_HWR_TRL_DP							0xAD000B08
MKTC_ST(MKTC_HWR_TRL_DP)
#define MKTC_HWR_ISC							0xAD000B09
MKTC_ST(MKTC_HWR_ISC)
#define MKTC_HWR_2DL							0xAD000B0A
MKTC_ST(MKTC_HWR_2DL)
#define MKTC_HWR_CLEANUP						0xAD000B0B
MKTC_ST(MKTC_HWR_CLEANUP)

#define MKTC_URSV_START							0xAD000C00
MKTC_ST(MKTC_URSV_START)
#define MKTC_URSV_UPDATEWRITEOPS				0xAD000C01
MKTC_ST(MKTC_URSV_UPDATEWRITEOPS)
#define MKTC_URSV_UPDATESTATUSVALS				0xAD000C03
MKTC_ST(MKTC_URSV_UPDATESTATUSVALS)
#define MKTC_URSV_UPDATESTATUSVALS_DONE			0xAD000C04
MKTC_ST(MKTC_URSV_UPDATESTATUSVALS_DONE)
#define MKTC_URSV_END							0xAD000C05
MKTC_ST(MKTC_URSV_END)

#define MKTC_STORETACONTEXT_START				0xAD000D00
MKTC_ST(MKTC_STORETACONTEXT_START)
#define MKTC_STORETACONTEXT_END					0xAD000D01
MKTC_ST(MKTC_STORETACONTEXT_END)
#define MKTC_LOADTACONTEXT_START				0xAD000D02
MKTC_ST(MKTC_LOADTACONTEXT_START)
#define MKTC_LOADTACONTEXT_END					0xAD000D03
MKTC_ST(MKTC_LOADTACONTEXT_END)
#define MKTC_STORE3DCONTEXT_START				0xAD000D04
MKTC_ST(MKTC_STORE3DCONTEXT_START)
#define MKTC_STORE3DCONTEXT_END					0xAD000D05
MKTC_ST(MKTC_STORE3DCONTEXT_END)
#define MKTC_LOAD3DCONTEXT_START				0xAD000D06
MKTC_ST(MKTC_LOAD3DCONTEXT_START)
#define MKTC_LOAD3DCONTEXT_END					0xAD000D07
MKTC_ST(MKTC_LOAD3DCONTEXT_END)

#define MKTC_FINDTA_POWERREQUEST				0xAD000E00
MKTC_ST(MKTC_FINDTA_POWERREQUEST)
#define MKTC_FINDTA_TA3D_OVERLAP_BLOCKED		0xAD000E01
MKTC_ST(MKTC_FINDTA_TA3D_OVERLAP_BLOCKED)
#define MKTC_FINDTA_RTDATA_RENDERING			0xAD000E02
MKTC_ST(MKTC_FINDTA_RTDATA_RENDERING)
#define MKTC_FINDTA_3DRC_DIFFERENT				0xAD000E03
MKTC_ST(MKTC_FINDTA_3DRC_DIFFERENT)
#define MKTC_FINDTA_WRITEOPSBLOCKED				0xAD000E04
MKTC_ST(MKTC_FINDTA_WRITEOPSBLOCKED)
#define MKTC_FINDTA_READOPSBLOCKED				0xAD000E05
MKTC_ST(MKTC_FINDTA_READOPSBLOCKED)
#define MKTC_FINDTA_RESIZE_PB					0xAD000E06
MKTC_ST(MKTC_FINDTA_RESIZE_PB)
#define MKTC_FINDTA_RESIZE_PB_BLOCKED			0xAD000E07
MKTC_ST(MKTC_FINDTA_RESIZE_PB_BLOCKED)
#define MKTC_FINDTA_SHRINK_PB					0xAD000E08
MKTC_ST(MKTC_FINDTA_SHRINK_PB)
#define	MKTC_FINDTA_TAPB_DIFFERENT				0xAD000E09
MKTC_ST(MKTC_FINDTA_TAPB_DIFFERENT)
#define	MKTC_FINDTA_TACONTEXT_DIFFERENT			0xAD000E0A
MKTC_ST(MKTC_FINDTA_TACONTEXT_DIFFERENT)
#define MKTC_FINDTA_TA2D_OVERLAP_BLOCKED		0xAD000E0B
MKTC_ST(MKTC_FINDTA_TA2D_OVERLAP_BLOCKED)
#define MKTC_FINDTA_CONTEXT_SUSPENDED			0xAD000E0C
MKTC_ST(MKTC_FINDTA_CONTEXT_SUSPENDED)
#define MKTC_FINDTA_SRC_READOPSBLOCKED			0xAD000E0D
MKTC_ST(MKTC_FINDTA_SRC_READOPSBLOCKED)
#define MKTC_FINDTA_SRC_WRITEOPSBLOCKED			0xAD000E0E
MKTC_ST(MKTC_FINDTA_SRC_WRITEOPSBLOCKED)
#define MKTC_FINDTA_READOPS2BLOCKED				0xAD000E0F
MKTC_ST(MKTC_FINDTA_READOPS2BLOCKED)

#define MKTC_CTRL_SRCREADOPSBLOCKED				0xAD000F00
MKTC_ST(MKTC_CTRL_SRCREADOPSBLOCKED)
#define MKTC_CTRL_SRCWRITEOPSBLOCKED			0xAD000F01
MKTC_ST(MKTC_CTRL_SRCWRITEOPSBLOCKED)
#define MKTC_CTRL_DSTREADOPSBLOCKED				0xAD000F02
MKTC_ST(MKTC_CTRL_DSTREADOPSBLOCKED)
#define MKTC_CTRL_DSTWRITEOPSBLOCKED			0xAD000F03
MKTC_ST(MKTC_CTRL_DSTWRITEOPSBLOCKED)
#define MKTC_CTRL_TARC_DIFFERENT				0xAD000F04
MKTC_ST(MKTC_CTRL_TARC_DIFFERENT)
#define MKTC_CTRL_CONTEXT_SUSPENDED				0xAD000F05
MKTC_ST(MKTC_CTRL_CONTEXT_SUSPENDED)
#define MKTC_CTRL_SRCREADOPS2BLOCKED			0xAD000F06
MKTC_ST(MKTC_CTRL_SRCREADOPS2BLOCKED)
#define MKTC_CTRL_3D_WRITEOPSBLOCKED			0xAD000F07
MKTC_ST(MKTC_CTRL_3D_WRITEOPSBLOCKED)
#define MKTC_CTRL_3D_READOPSBLOCKED				0xAD000F08
MKTC_ST(MKTC_CTRL_3D_READOPSBLOCKED)

#define MKTC_DPTA_START							0xAD001000
MKTC_ST(MKTC_DPTA_START)
#define MKTC_DPTA_UPDATESTATUSVALS				0xAD001001
MKTC_ST(MKTC_DPTA_UPDATESTATUSVALS)
#define MKTC_DPTA_UPDATESTATUSVALS_DONE			0xAD001002
MKTC_ST(MKTC_DPTA_UPDATESTATUSVALS_DONE)
#define MKTC_DPTA_NORENDER						0xAD001003
MKTC_ST(MKTC_DPTA_NORENDER)
#define MKTC_DPTA_MEMFREE						0xAD001004
MKTC_ST(MKTC_DPTA_MEMFREE)
#define MKTC_DPTA_INC_COMPLETECOUNT				0xAD001005
MKTC_ST(MKTC_DPTA_INC_COMPLETECOUNT)

#define MKTC_INVALDC 							0xAD001100
MKTC_ST(MKTC_INVALDC)
#define MKTC_INVALPT 							0xAD001101
MKTC_ST(MKTC_INVALPT)
#define MKTC_INVALSLC							0xAD001102
MKTC_ST(MKTC_INVALSLC)
#define MKTC_INVALDATA							0xAD001103
MKTC_ST(MKTC_INVALDATA)

#define MKTC_RESTARTTA							0xAD001200
MKTC_ST(MKTC_RESTARTTA)
#define MKTC_CSABORTNONGBL						0xAD001201
MKTC_ST(MKTC_CSABORTNONGBL)
#define MKTC_CSABORTALL							0xAD001202
MKTC_ST(MKTC_CSABORTALL)
#define MKTC_CSRENDERINPROGRESS					0xAD001203
MKTC_ST(MKTC_CSRENDERINPROGRESS)
#define MKTC_TATERMRENDERINPROGRESS				0xAD001204
MKTC_ST(MKTC_TATERMRENDERINPROGRESS)
#define MKTC_RESTARTTANORENDER					0xAD001205
MKTC_ST(MKTC_RESTARTTANORENDER)
#define MKTC_SPM_KICKRENDER						0xAD001206
MKTC_ST(MKTC_SPM_KICKRENDER)
#define MKTC_SPM_RESUME_ABORTCOMPLETE			0xAD001208
MKTC_ST(MKTC_SPM_RESUME_ABORTCOMPLETE)
#define	MKTC_RESUMEVDM							0xAD001209
MKTC_ST(MKTC_RESUMEVDM)
#define	MKTC_REMOVE_RESERVE_MEM					0xAD00120A
MKTC_ST(MKTC_REMOVE_RESERVE_MEM)
#define	MKTC_INCREASEZLSTHRESHOLD				0xAD00120B
MKTC_ST(MKTC_INCREASEZLSTHRESHOLD)
#define MKTC_CSFORCEABORTALL					0xAD00120C
MKTC_ST(MKTC_CSFORCEABORTALL)

#define MKTC_DUMMY_DEPTH						0xAD00120D
MKTC_ST(MKTC_DUMMY_DEPTH)
#define MKTC_DUMMY_DEPTH_CS						0xAD00120E
MKTC_ST(MKTC_DUMMY_DEPTH_CS)

#define MKTC_MTETE_OOM							0xAD00120F
MKTC_ST(MKTC_MTETE_OOM)
#define	MKTC_MTETE_OOM_FIRST_STORE_REF			0xAD001210
MKTC_ST(MKTC_MTETE_OOM_FIRST_STORE_REF)
#define MKTC_MERGE_STATE_TABLES					0xAD001211
MKTC_ST(MKTC_MERGE_STATE_TABLES)
#define MKTC_NO_PAGES_LEFT_FOR_23055			0xAD001212
MKTC_ST(MKTC_NO_PAGES_LEFT_FOR_23055)
#define MKTC_NO_STATE_MODS						0xAD001213
MKTC_ST(MKTC_NO_STATE_MODS)
#define MKTC_FIND_MTE_PAGE_IN_STATE				0xAD001214
MKTC_ST(MKTC_FIND_MTE_PAGE_IN_STATE)
#define MKTC_MTE_PAGE_FOUND						0xAD001215
MKTC_ST(MKTC_MTE_PAGE_FOUND)
#define MKTC_MOVE_MTE_PAGE_TO_TA_STATE			0xAD001216
MKTC_ST(MKTC_MOVE_MTE_PAGE_TO_TA_STATE)
#define MKTC_MOVE_MTE_PAGE_TO_TA_STATE_END		0xAD001217
MKTC_ST(MKTC_MOVE_MTE_PAGE_TO_TA_STATE_END)
#define MKTC_ZERO_ZLS_THRESHOLD					0xAD001218
MKTC_ST(MKTC_ZERO_ZLS_THRESHOLD)
#define MKTC_RESTORE_ZLS_THRESHOLD				0xAD001219
MKTC_ST(MKTC_RESTORE_ZLS_THRESHOLD)
#define MKTC_FIND_MTE_PAGE_IN_CSM				0xAD00121A
MKTC_ST(MKTC_FIND_MTE_PAGE_IN_CSM)
#define MKTC_REISSUE_MTE_PAGE					0xAD00121B
MKTC_ST(MKTC_REISSUE_MTE_PAGE)
#define MKTC_REISSUE_MTE_PAGE_REQUIRED			0xAD00121C
MKTC_ST(MKTC_REISSUE_MTE_PAGE_REQUIRED)
#define MKTC_REISSUE_MTE_PAGE_END				0xAD00121D
MKTC_ST(MKTC_REISSUE_MTE_PAGE_END)
#define MKTC_RESET_TE_PSG						0xAD00121E
MKTC_ST(MKTC_RESET_TE_PSG)

#define MKTC_OOM_WRITEOPSBLOCKED				0xAD00121F
MKTC_ST(MKTC_OOM_WRITEOPSBLOCKED)
#define MKTC_OOM_READOPSBLOCKED					0xAD001220
MKTC_ST(MKTC_OOM_READOPSBLOCKED)
#define MKTC_OOM_SRC_WRITEOPSBLOCKED			0xAD001221
MKTC_ST(MKTC_OOM_SRC_WRITEOPSBLOCKED)
#define MKTC_OOM_SRC_READOPSBLOCKED				0xAD001222
MKTC_ST(MKTC_OOM_SRC_READOPSBLOCKED)
#define MKTC_OOM_SPM_DEADLOCK					0xAD001223
MKTC_ST(MKTC_OOM_SPM_DEADLOCK)
#define MKTC_OOM_SPM_DEADLOCK_MEM_ADDED			0xAD001224
MKTC_ST(MKTC_OOM_SPM_DEADLOCK_MEM_ADDED)
#define MKTC_RESET								0xAD001225
MKTC_ST(MKTC_RESET)
#define	MKTC_SPM_INVALID_ZLSCONFIG				0xAD001226
MKTC_ST(MKTC_SPM_INVALID_ZLSCONFIG)

#define MKTC_OOM_TYPE_MT						0xAD00122A
MKTC_ST(MKTC_OOM_TYPE_MT)
#define MKTC_OOM_TYPE_GLOBAL					0xAD001230
MKTC_ST(MKTC_OOM_TYPE_GLOBAL)
#define MKTC_OOM_CAUSE_GBL_OOM					0xAD001231
MKTC_ST(MKTC_OOM_CAUSE_GBL_OOM)
#define MKTC_OOM_RESTORE_LIST_SIZE				0xAD001232
MKTC_ST(MKTC_OOM_RESTORE_LIST_SIZE)

#define MKTC_CHECK_MTE_PAGE_REISSUE				0xAD001240
MKTC_ST(MKTC_CHECK_MTE_PAGE_REISSUE)
#define MKTC_CPRI_VALID_ENTRIES					0xAD001241
MKTC_ST(MKTC_CPRI_VALID_ENTRIES)
#define MKTC_CPRI_STORE_DPLIST					0xAD001242
MKTC_ST(MKTC_CPRI_STORE_DPLIST)
#define MKTC_CPRI_STORE_OTPM_CSM				0xAD001243
MKTC_ST(MKTC_CPRI_STORE_OTPM_CSM)
#define MKTC_CPRI_ABORT_MT_IDX					0xAD001244
MKTC_ST(MKTC_CPRI_ABORT_MT_IDX)
#define MKTC_CPRI_ABORT_CORE_IDX				0xAD001245
MKTC_ST(MKTC_CPRI_ABORT_CORE_IDX)
#define MKTC_CPRI_CSM_TABLE_DATA				0xAD001246
MKTC_ST(MKTC_CPRI_CSM_TABLE_DATA)
#define MKTC_CPRI_PIM_DATA						0xAD001247
MKTC_ST(MKTC_CPRI_PIM_DATA)
#define MKTC_CPRI_DO_CIRCULAR_TEST				0xAD001248
MKTC_ST(MKTC_CPRI_DO_CIRCULAR_TEST)
#define MKTC_CPRI_WRITE_ENTRIES					0xAD001249
MKTC_ST(MKTC_CPRI_WRITE_ENTRIES)

#define	MKTC_MTE_ENTRY_NOT_IN_ANY_LIST			0xAD001250
MKTC_ST(MKTC_MTE_ENTRY_NOT_IN_ANY_LIST)

#define	MKTC_SPMAC_IGNORE_TERMINATE				0xAD001251
MKTC_ST(MKTC_SPMAC_IGNORE_TERMINATE)

#define MKTC_SPMAC_REQUEST_3D_TIMEOUT			0xAD001252
MKTC_ST(MKTC_SPMAC_REQUEST_3D_TIMEOUT)
#define MKTC_SPMAC_3D_TIMEOUT_COMPLETE			0xAD001253
MKTC_ST(MKTC_SPMAC_3D_TIMEOUT_COMPLETE)
#define MKTC_OOM_READOPS2BLOCKED				0xAD001254
MKTC_ST(MKTC_OOM_READOPS2BLOCKED)

/* PB Load/store status */
#define MKTC_LOADTAPB_START						0xAD001300
MKTC_ST(MKTC_LOADTAPB_START)
#define MKTC_LOADTAPB_END						0xAD001301
MKTC_ST(MKTC_LOADTAPB_END)
#define MKTC_STORETAPB_START					0xAD001302
MKTC_ST(MKTC_STORETAPB_START)
#define MKTC_STORETAPB_END						0xAD001303
MKTC_ST(MKTC_STORETAPB_END)
#define MKTC_LOAD3DPB_START						0xAD001304
MKTC_ST(MKTC_LOAD3DPB_START)
#define MKTC_LOAD3DPB_END						0xAD001305
MKTC_ST(MKTC_LOAD3DPB_END)
#define MKTC_STORE3DPB_START					0xAD001306
MKTC_ST(MKTC_STORE3DPB_START)
#define MKTC_STORE3DPB_END						0xAD001307
MKTC_ST(MKTC_STORE3DPB_END)
#define MKTC_LOADTAPB_PAGETABLE_DONE			0xAD001308
MKTC_ST(MKTC_LOADTAPB_PAGETABLE_DONE)
#define MKTC_LOAD3DPB_PAGETABLE_DONE			0xAD001309
MKTC_ST(MKTC_LOAD3DPB_PAGETABLE_DONE)

#define MKTC_TIMER_RC_CLEANUP					0xAD001400
MKTC_ST(MKTC_TIMER_RC_CLEANUP)
#define MKTC_TIMER_RC_CLEANUP_DONE				0xAD001401
MKTC_ST(MKTC_TIMER_RC_CLEANUP_DONE)
#define MKTC_TIMER_RC_CLEANUP_BUSY				0xAD001402
MKTC_ST(MKTC_TIMER_RC_CLEANUP_BUSY)
#define MKTC_TIMER_RT_CLEANUP					0xAD001410
MKTC_ST(MKTC_TIMER_RT_CLEANUP)
#define MKTC_TIMER_RT_CLEANUP_DONE				0xAD001411
MKTC_ST(MKTC_TIMER_RT_CLEANUP_DONE)
#define MKTC_TIMER_RT_CLEANUP_PENDING			0xAD001412
MKTC_ST(MKTC_TIMER_RT_CLEANUP_PENDING)
#define MKTC_TIMER_RT_CLEANUP_TIDYPARTIALLIST	0xAD001413
MKTC_ST(MKTC_TIMER_RT_CLEANUP_TIDYPARTIALLIST)
#define MKTC_TIMER_RT_CLEANUP_BUSY				0xAD001414
MKTC_ST(MKTC_TIMER_RT_CLEANUP_BUSY)
#define MKTC_TIMER_TC_CLEANUP					0xAD001420
MKTC_ST(MKTC_TIMER_TC_CLEANUP)
#define MKTC_TIMER_TC_CLEANUP_DONE				0xAD001421
MKTC_ST(MKTC_TIMER_TC_CLEANUP_DONE)
#define MKTC_TIMER_TC_CLEANUP_BUSY				0xAD001422
MKTC_ST(MKTC_TIMER_TC_CLEANUP_BUSY)
#define MKTC_TIMER_2DC_CLEANUP					0xAD001430
MKTC_ST(MKTC_TIMER_2DC_CLEANUP)
#define MKTC_TIMER_2DC_CLEANUP_DONE				0xAD001431
MKTC_ST(MKTC_TIMER_2DC_CLEANUP_DONE)
#define MKTC_TIMER_2DC_CLEANUP_BUSY				0xAD001432
MKTC_ST(MKTC_TIMER_2DC_CLEANUP_BUSY)
#define MKTC_TIMER_SHAREDPBDESC_CLEANUP			0xAD001440
MKTC_ST(MKTC_TIMER_SHAREDPBDESC_CLEANUP)


#define MKTC_TIMER_ISP_SWITCH_POTENTIAL_LOCKUP	0xAD001450
MKTC_ST(MKTC_TIMER_ISP_SWITCH_POTENTIAL_LOCKUP)
#define MKTC_TIMER_ISP_SWITCH_FORCE_SWITCH		0xAD001451
MKTC_ST(MKTC_TIMER_ISP_SWITCH_FORCE_SWITCH)

#define MKTC_UTSO_UPDATEREADOPS					0xAD001600
MKTC_ST(MKTC_UTSO_UPDATEREADOPS)
#define MKTC_UTSO_UPDATEWRITEOPS				0xAD001601
MKTC_ST(MKTC_UTSO_UPDATEWRITEOPS)

#define MKTC_TAFINISHED_UPDATESTATUSVALS		0xAD001700
MKTC_ST(MKTC_TAFINISHED_UPDATESTATUSVALS)
#define MKTC_TAFINISHED_UPDATESTATUSVALS_DONE	0xAD001701
MKTC_ST(MKTC_TAFINISHED_UPDATESTATUSVALS_DONE)
#define MKTC_TAFINISHED_NORENDER				0xAD001702
MKTC_ST(MKTC_TAFINISHED_NORENDER)
#define MKTC_TAFINISHED_LASTKICK				0xAD001703
MKTC_ST(MKTC_TAFINISHED_LASTKICK)
#define MKTC_TAFINISHED_FINDRENDER				0xAD001704
MKTC_ST(MKTC_TAFINISHED_FINDRENDER)
#define MKTC_TAFINISHED_FINDTA					0xAD001705
MKTC_ST(MKTC_TAFINISHED_FINDTA)
#define MKTC_TAFINISHED_END						0xAD001706
MKTC_ST(MKTC_TAFINISHED_END)
#define MKTC_TAF_SPM_DEADLOCK_MEM_REMOVED		0xAD001707
MKTC_ST(MKTC_TAF_SPM_DEADLOCK_MEM_REMOVED)
#define MKTC_TAF_RESERVE_MEM					0xAD001708
MKTC_ST(MKTC_TAF_RESERVE_MEM)
#define MKTC_TAF_RESERVE_MEM_REQUEST_RENDER		0xAD001709
MKTC_ST(MKTC_TAF_RESERVE_MEM_REQUEST_RENDER)
#define MKTC_TAF_RESERVE_FREE_RENDER_FINISHED	0xAD00170A
MKTC_ST(MKTC_TAF_RESERVE_FREE_RENDER_FINISHED)
#define MKTC_TAF_RESERVE_FREE_DUMMY_RENDER		0xAD00170B
MKTC_ST(MKTC_TAF_RESERVE_FREE_DUMMY_RENDER)
#define MKTC_TAF_DEBUG_SAS						0xAD00170C
MKTC_ST(MKTC_TAF_DEBUG_SAS)
#define MKTC_TAFINISHED_NOCONTEXTSWITCH			0xAD00170D
MKTC_ST(MKTC_TAFINISHED_NOCONTEXTSWITCH)

#define MKTC_TAFINISHED_TERM_COMPLETE_START		0xAD001710
MKTC_ST(MKTC_TAFINISHED_TERM_COMPLETE_START)
#define MKTC_TAFINISHED_TERM_COMPLETE_END		0xAD001711
MKTC_ST(MKTC_TAFINISHED_TERM_COMPLETE_END)

#define MKTC_TAFINISHED_DPMPAGERECYCLING			0xAD001720
MKTC_ST(MKTC_TAFINISHED_DPMPAGERECYCLING)

#define MKTC_2DEVENT_2DCOMPLETE					0xAD001800
MKTC_ST(MKTC_2DEVENT_2DCOMPLETE)
#define MKTC_2DEVENT_END						0xAD001801
MKTC_ST(MKTC_2DEVENT_END)
#define	MKTC_2DLB_2DCOMPLETE					0xAD001802
MKTC_ST(MKTC_2DLB_2DCOMPLETE)
#define MKTC_2DLB_FIND2D						0xAD001803
MKTC_ST(MKTC_2DLB_FIND2D)
#define MKTC_2DLB_END							0xAD001804
MKTC_ST(MKTC_2DLB_END)
#define MKTC_2DCOMPLETE_START					0xAD001805
MKTC_ST(MKTC_2DCOMPLETE_START)
#define MKTC_2DCOMPLETE_END						0xAD001806
MKTC_ST(MKTC_2DCOMPLETE_END)
#define MKTC_KICK2D_START						0xAD001807
MKTC_ST(MKTC_KICK2D_START)
#define MKTC_KICK2D_END							0xAD001808
MKTC_ST(MKTC_KICK2D_END)
#define MKTC_DUMMYPROC2D						0xAD001809
MKTC_ST(MKTC_DUMMYPROC2D)
#define MKTC_FTD_SRCREADOPSBLOCKED				0xAD00180A
MKTC_ST(MKTC_FTD_SRCREADOPSBLOCKED)
#define MKTC_FTD_SRCWRITEOPSBLOCKED				0xAD00180B
MKTC_ST(MKTC_FTD_SRCWRITEOPSBLOCKED)
#define MKTC_FTD_DSTREADOPSBLOCKED				0xAD00180C
MKTC_ST(MKTC_FTD_DSTREADOPSBLOCKED)
#define MKTC_FTD_DSTWRITEOPSBLOCKED				0xAD00180D
MKTC_ST(MKTC_FTD_DSTWRITEOPSBLOCKED)
#define MKTC_FTD_TA2D_OVERLAP_BLOCKED			0xAD00180E
MKTC_ST(MKTC_FTD_TA2D_OVERLAP_BLOCKED)
#define MKTC_U2DSO_UPDATEREADOPS				0xAD00180F
MKTC_ST(MKTC_U2DSO_UPDATEREADOPS)
#define MKTC_U2DSO_UPDATEWRITEOPS				0xAD001810
MKTC_ST(MKTC_U2DSO_UPDATEWRITEOPS)
#define MKTC_FTD_TAOPSBLOCKED					0xAD001811
MKTC_ST(MKTC_FTD_TAOPSBLOCKED)
#define MKTC_KICK2D_2DSLAVEPORT					0xAD001812
MKTC_ST(MKTC_KICK2D_2DSLAVEPORT)
#define MKTC_KICK2D_2DSLAVEPORT_DONE			0xAD001813
MKTC_ST(MKTC_KICK2D_2DSLAVEPORT_DONE)
#define MKTC_FTD_CONTEXT_SUSPENDED				0xAD001814
MKTC_ST(MKTC_FTD_CONTEXT_SUSPENDED)
#define MKTC_KICK2D_PID							0xAD001815
MKTC_ST(MKTC_KICK2D_PID)
#define MKTC_FIND2D_ADDR_SPACE_DIFFERENT		0xAD001816
MKTC_ST(MKTC_FIND2D_ADDR_SPACE_DIFFERENT)
#define MKTC_FTD_3DOPSBLOCKED					0xAD001817
MKTC_ST(MKTC_FTD_3DOPSBLOCKED)
#define MKTC_FTD_DSTREADOPS2BLOCKED				0xAD001818
MKTC_ST(MKTC_FTD_DSTREADOPS2BLOCKED)
#define MKTC_U2DSO_UPDATESTATUSVALS				0xAD001819
MKTC_ST(MKTC_U2DSO_UPDATESTATUSVALS)
#define MKTC_U2DSO_UPDATESTATUSVALS_DONE		0xAD00181A
MKTC_ST(MKTC_U2DSO_UPDATESTATUSVALS_DONE)

#define MKTC_FCM_START							0xAD001900
MKTC_ST(MKTC_FCM_START)
#define MKTC_FCM_END							0xAD001901
MKTC_ST(MKTC_FCM_END)
#define MKTC_FCM_PB_SAME						0xAD001902
MKTC_ST(MKTC_FCM_PB_SAME)
#define MKTC_FCM_TQ_IN_PROGESS					0xAD001903
MKTC_ST(MKTC_FCM_TQ_IN_PROGESS)
#define MKTC_FCM_TQ_MEMCONTEXT_DIFFERENT		0xAD001904
MKTC_ST(MKTC_FCM_TQ_MEMCONTEXT_DIFFERENT)

#define MKTC_TIMER_ACTIVE_POWER					0xAD001A00
MKTC_ST(MKTC_TIMER_ACTIVE_POWER)
#define MKTC_TIMER_POWER_3D_ACTIVE				0xAD001A01
MKTC_ST(MKTC_TIMER_POWER_3D_ACTIVE)
#define MKTC_TIMER_POWER_TA_ACTIVE				0xAD001A02
MKTC_ST(MKTC_TIMER_POWER_TA_ACTIVE)
#define MKTC_TIMER_POWER_2D_ACTIVE				0xAD001A03
MKTC_ST(MKTC_TIMER_POWER_2D_ACTIVE)
#define MKTC_TIMER_POWER_PENDING_EVENTS			0xAD001A04
MKTC_ST(MKTC_TIMER_POWER_PENDING_EVENTS)
#define MKTC_TIMER_POWER_IDLE					0xAD001A05
MKTC_ST(MKTC_TIMER_POWER_IDLE)
#define MKTC_TIMER_POWER_OFF					0xAD001A06
MKTC_ST(MKTC_TIMER_POWER_OFF)
#define	MKTC_TIMER_POWER_CCB_ERROR				0xAD001A07
MKTC_ST(MKTC_TIMER_POWER_CCB_ERROR)
#define	MKTC_TIMER_POWER_RESTART_IMMEDIATE		0xAD001A08
MKTC_ST(MKTC_TIMER_POWER_RESTART_IMMEDIATE)
#define MKTC_TIMER_UPDATE_DONE					0xAD001A09
MKTC_ST(MKTC_TIMER_UPDATE_DONE)

#define MKTC_3DCONTEXT_SWITCH					0xAD001B00
MKTC_ST(MKTC_3DCONTEXT_SWITCH)
#define MKTC_3DCONTEXT_SWITCH_END				0xAD001B01
MKTC_ST(MKTC_3DCONTEXT_SWITCH_END)

#define MKTC_TACONTEXT_SWITCH					0xAD001C00
MKTC_ST(MKTC_TACONTEXT_SWITCH)
#define MKTC_TACONTEXT_SWITCH_END				0xAD001C02
MKTC_ST(MKTC_TACONTEXT_SWITCH_END)

#define MKTC_GETMISCINFO_MEMREAD_START			0xAD001D00
MKTC_ST(MKTC_GETMISCINFO_MEMREAD_START)
#define MKTC_GETMISCINFO_MEMREAD_END			0xAD001D01
MKTC_ST(MKTC_GETMISCINFO_MEMREAD_END)
#define MKTC_GETMISCINFO_MEMWRITE_START			0xAD001D02
MKTC_ST(MKTC_GETMISCINFO_MEMWRITE_START)
#define MKTC_GETMISCINFO_MEMWRITE_END			0xAD001D03
MKTC_ST(MKTC_GETMISCINFO_MEMWRITE_END)

#define	MKTC_HALTTA								0xAD001E00
MKTC_ST(MKTC_HALTTA)
#define MKTC_HTA_SET_FLAG						0xAD001E01
MKTC_ST(MKTC_HTA_SET_FLAG)
#define MKTC_HTA_SAVE_COMPLEX_PTR				0xAD001E02
MKTC_ST(MKTC_HTA_SAVE_COMPLEX_PTR)
#define MKTC_HALTTA_END							0xAD001E03
MKTC_ST(MKTC_HALTTA_END)

#define	MKTC_RESUMETA							0xAD001F00
MKTC_ST(MKTC_RESUMETA)
#define	MKTC_RTA_CONTEXT_LOADED					0xAD001F01
MKTC_ST(MKTC_RTA_CONTEXT_LOADED)
#define	MKTC_RTA_MTE_STATE_KICKED				0xAD001F02
MKTC_ST(MKTC_RTA_MTE_STATE_KICKED)
#define MKTC_RTA_CMPLX_GEOM_PRESENT				0xAD001F03
MKTC_ST(MKTC_RTA_CMPLX_GEOM_PRESENT)
#define	MKTC_RTA_CMPLX_STATE_KICKED				0xAD001F04
MKTC_ST(MKTC_RTA_CMPLX_STATE_KICKED)
#define	MKTC_RTA_CHECK_NEXT_SA_PROG				0xAD001F05
MKTC_ST(MKTC_RTA_CHECK_NEXT_SA_PROG)
#define MKTC_RTA_CORE_COMPLETED					0xAD001F06
MKTC_ST(MKTC_RTA_CORE_COMPLETED)
#define MKTC_RTA_DEBUG_SAS						0xAD001F07
MKTC_ST(MKTC_RTA_DEBUG_SAS)
#define MKTC_RESUMETA_END						0xAD001F0F
MKTC_ST(MKTC_RESUMETA_END)

#define MKTC_RENDERHALT							0xAD002000
MKTC_ST(MKTC_RENDERHALT)
#define MKTC_RH_CLEARFLAGS						0xAD002001
MKTC_ST(MKTC_RH_CLEARFLAGS)
#define MKTC_RH_CTRL_ADDR						0xAD002002
MKTC_ST(MKTC_RH_CTRL_ADDR)
#define MKTC_RH_RGN_ADDR						0xAD002003
MKTC_ST(MKTC_RH_RGN_ADDR)
#define MKTC_RH_EMPTY_TILE						0xAD002004
MKTC_ST(MKTC_RH_EMPTY_TILE)
#define MKTC_RH_EMPTY_LAST_TILE					0xAD002005
MKTC_ST(MKTC_RH_EMPTY_LAST_TILE)
#define MKTC_RH_3D_TIMEOUT						0xAD002006
MKTC_ST(MKTC_RH_3D_TIMEOUT)
#define MKTC_RH_NOT_EMPTY						0xAD002007
MKTC_ST(MKTC_RH_NOT_EMPTY)
#define MKTC_RH_OBJECT_COMPLETE					0xAD002008
MKTC_ST(MKTC_RH_OBJECT_COMPLETE)
#define MKTC_RH_STREAM_LINK						0xAD002009
MKTC_ST(MKTC_RH_STREAM_LINK)
#define MKTC_RH_OBJECT_INCOMPLETE				0xAD00200A
MKTC_ST(MKTC_RH_OBJECT_INCOMPLETE)
#define MKTC_RH_PRIM_MASK_PRESENT				0xAD00200B
MKTC_ST(MKTC_RH_PRIM_MASK_PRESENT)
#define MKTC_RH_BYTE_MASK_PRESENT				0xAD00200C
MKTC_ST(MKTC_RH_BYTE_MASK_PRESENT)
#define MKTC_RH_BYTE_MASK_ZERO					0xAD00200D
MKTC_ST(MKTC_RH_BYTE_MASK_ZERO)
#define MKTC_RH_PRIM_MASK_ZERO					0xAD00200E
MKTC_ST(MKTC_RH_PRIM_MASK_ZERO)
#define MKTC_RH_INVALIDATE_OBJECTS				0xAD00200F
MKTC_ST(MKTC_RH_INVALIDATE_OBJECTS)
#define MKTC_RH_OBJECTS_INVALIDATED				0xAD002010
MKTC_ST(MKTC_RH_OBJECTS_INVALIDATED)
#define MKTC_RH_DPM_RGN_PARSER_IDLE				0xAD002011
MKTC_ST(MKTC_RH_DPM_RGN_PARSER_IDLE)
#define MKTC_RH_NEXT_RGN_BASE					0xAD002012
MKTC_ST(MKTC_RH_NEXT_RGN_BASE)
#define MKTC_RH_OCC_EXIT						0xAD002013
MKTC_ST(MKTC_RH_OCC_EXIT)
#define MKTC_RH_STILL_RUNNING					0xAD002020
MKTC_ST(MKTC_RH_STILL_RUNNING)
#define MKTC_RH_CLEARMCI						0xAD002021
MKTC_ST(MKTC_RH_CLEARMCI)
#define MKTC_RH_EOR								0xAD002022
MKTC_ST(MKTC_RH_EOR)
#define MKTC_RENDERHALT_END						0xAD002030
MKTC_ST(MKTC_RENDERHALT_END)

#define	MKTC_FIND3D_POWERREQUEST				0xAD002100
MKTC_ST(MKTC_FIND3D_POWERREQUEST)

#define	MKTC_FIND2D_POWERREQUEST				0xAD002200
MKTC_ST(MKTC_FIND2D_POWERREQUEST)

#define	MKTC_UKERNEL_INIT						0xAD002300
MKTC_ST(MKTC_UKERNEL_INIT)
#define MKTC_UKERNEL_INIT_DCS_COMPLETE			0xAD002301
MKTC_ST(MKTC_UKERNEL_INIT_DCS_COMPLETE)
#define MKTC_UKERNEL_INIT_VDMKICK_COMPLETE		0xAD002303
MKTC_ST(MKTC_UKERNEL_INIT_VDMKICK_COMPLETE)

#define MKTC_KICKTRANSFERRENDER_START			0xAD002400
MKTC_ST(MKTC_KICKTRANSFERRENDER_START)
#define MKTC_KICKTRANSFERRENDER_ISP_START		0xAD002401
MKTC_ST(MKTC_KICKTRANSFERRENDER_ISP_START)
#define MKTC_KICKTRANSFERRENDER_END				0xAD002402
MKTC_ST(MKTC_KICKTRANSFERRENDER_END)
#define MKTC_DUMMYPROCTRANSFER					0xAD002403
MKTC_ST(MKTC_DUMMYPROCTRANSFER)
#define MKTC_KTR_TQFENCE						0xAD002404
MKTC_ST(MKTC_KTR_TQFENCE)
#define MKTC_KICKTRANSFERRENDER_PID				0xAD002405
MKTC_ST(MKTC_KICKTRANSFERRENDER_PID)

#define MKTC_HOSTKICK_CLEANUP_RT				0xAD002500
MKTC_ST(MKTC_HOSTKICK_CLEANUP_RT)
#define MKTC_HOSTKICK_CLEANUP_RC				0xAD002501
MKTC_ST(MKTC_HOSTKICK_CLEANUP_RC)
#define MKTC_HOSTKICK_CLEANUP_TC				0xAD002502
MKTC_ST(MKTC_HOSTKICK_CLEANUP_TC)
#define MKTC_HOSTKICK_CLEANUP_2DC				0xAD002503
MKTC_ST(MKTC_HOSTKICK_CLEANUP_2DC)
#define MKTC_HOSTKICK_CLEANUP_PB				0xAD002504
MKTC_ST(MKTC_HOSTKICK_CLEANUP_PB)
#define MKTC_HOSTKICK_GETMISCINFO				0xAD002505
MKTC_ST(MKTC_HOSTKICK_GETMISCINFO)
#define MKTC_HOSTKICK_DATABREAKPOINT			0xAD002506
MKTC_ST(MKTC_HOSTKICK_DATABREAKPOINT)
#define MKTC_HOSTKICK_SETHWPERFSTATUS			0xAD002507
MKTC_ST(MKTC_HOSTKICK_SETHWPERFSTATUS)

#define MKTC_ZEROPC								0xAD002600
MKTC_ST(MKTC_ZEROPC)

#define MKTC_ASSERT_FAIL						0xAD002700
MKTC_ST(MKTC_ASSERT_FAIL)

#define MKTC_SDLB_ILLEGAL						0xAD002800
MKTC_ST(MKTC_SDLB_ILLEGAL)

#define MKTC_SPMEVENT_OUTOFMEM					0xAD002901
MKTC_ST(MKTC_SPMEVENT_OUTOFMEM)
#define MKTC_SPMEVENT_TATERMINATE				0xAD002902
MKTC_ST(MKTC_SPMEVENT_TATERMINATE)
#define MKTC_SPMEVENT_END						0xAD002904
MKTC_ST(MKTC_SPMEVENT_END)

#define MKTC_SPMLB_OUTOFMEM						0xAD002981
MKTC_ST(MKTC_SPMLB_OUTOFMEM)
#define MKTC_SPMLB_TATERMINATE					0xAD002982
MKTC_ST(MKTC_SPMLB_TATERMINATE)
#define MKTC_SPMLB_SPMRENDERFINSHED				0xAD002983
MKTC_ST(MKTC_SPMLB_SPMRENDERFINSHED)
#define MKTC_SPMLB_END							0xAD002985
MKTC_ST(MKTC_SPMLB_END)

#define MKTC_SPM_CHECK_MT_DEADLOCK				0xAD002991
MKTC_ST(MKTC_SPM_CHECK_MT_DEADLOCK)
#define MKTC_SPM_CHECK_GLOBAL_DEADLOCK			0xAD002992
MKTC_ST(MKTC_SPM_CHECK_GLOBAL_DEADLOCK)
#define MKTC_SPM_RESERVE_ADDED					0xAD002993
MKTC_ST(MKTC_SPM_RESERVE_ADDED)
#define MKTC_SPM_FORCE_GLOBAL_OOM_FAILED		0xAD00299E
MKTC_ST(MKTC_SPM_FORCE_GLOBAL_OOM_FAILED)
#define MKTC_SPM_DEADLOCK_MEM_FAILED			0xAD00299F
MKTC_ST(MKTC_SPM_DEADLOCK_MEM_FAILED)

#define MKTC_IBC_ILLEGAL						0xAD002A00
MKTC_ST(MKTC_IBC_ILLEGAL)

#define MKTC_HWP_CLEARCOUNTERS					0xAD002B00
MKTC_ST(MKTC_HWP_CLEARCOUNTERS)

#define MKTC_TA_FRAMENUM						0xAD002C00
MKTC_ST(MKTC_TA_FRAMENUM)
#define MKTC_3D_FRAMENUM						0xAD002C01
MKTC_ST(MKTC_3D_FRAMENUM)
#define MKTC_SPM3D_FRAMENUM						0xAD002C02
MKTC_ST(MKTC_SPM3D_FRAMENUM)

#define MKTC_HKTA_RENDERCONTEXT					0xAD002D00
MKTC_ST(MKTC_HKTA_RENDERCONTEXT)
#define MKTC_IDLECORE_REFCOUNT_FAIL				0xAD002E00
MKTC_ST(MKTC_IDLECORE_REFCOUNT_FAIL)

#define MKTC_MCISTATE_NOT_CLEARED				0xAD002F00
MKTC_ST(MKTC_MCISTATE_NOT_CLEARED)

#define MKTC_LOWERED_TO_PDS_THRESHOLD				0xAD003000
MKTC_ST(MKTC_LOWERED_TO_PDS_THRESHOLD)
#define MKTC_REDUCE_MAX_VTX_PARTITIONS				0xAD003001
MKTC_ST(MKTC_REDUCE_MAX_VTX_PARTITIONS)
#define MKTC_KTAOVERRIDE_MAX_VTX_PARTITIONS			0xAD003002
MKTC_ST(MKTC_KTAOVERRIDE_MAX_VTX_PARTITIONS)
#define MKTC_KTANOOVERRIDE_MAX_VTX_PARTITIONS			0xAD003003
MKTC_ST(MKTC_KTANOOVERRIDE_MAX_VTX_PARTITIONS)

#define MKTC_IPRB_NORENDERDETAILS				0xAD003010
MKTC_ST(MKTC_IPRB_NORENDERDETAILS)
#define MKTC_IPRB_HAVERENDERDETAILS				0xAD003011
MKTC_ST(MKTC_IPRB_HAVERENDERDETAILS)

#define MKTC_RENDER_OUT_OF_ORDER				0xAD003020
MKTC_ST(MKTC_RENDER_OUT_OF_ORDER)
#define MKTC_RENDER_NOT_OUT_OF_ORDER			0xAD003021
MKTC_ST(MKTC_RENDER_NOT_OUT_OF_ORDER)

#define MKTC_ZLS_IDLE_BEGIN						0xAD003030
MKTC_ST(MKTC_ZLS_IDLE_BEGIN)
#define MKTC_ZLS_ISP_CLK_GATING_EN				0xAD003031
MKTC_ST(MKTC_ZLS_ISP_CLK_GATING_EN)
#define MKTC_ZLS_IDLE_END						0xAD003032
MKTC_ST(MKTC_ZLS_IDLE_END)

#endif /*  __SGX_UKERNEL_STATUS_CODES_H__ */

/******************************************************************************
 End of file (sgx_ukernel_status_codes.h)
******************************************************************************/
