/* linux/arch/arm/mach-exynos/include/mach/asv-exynos5430.h
*
* Copyright (c) 2013 Samsung Electronics Co., Ltd.
*              http://www.samsung.com/
*
* EXYNOS5430 - Adoptive Support Voltage Header file
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_EXYNOS5430_ASV_H
#define __ASM_ARCH_EXYNOS5430_ASV_H __FILE__

#define ARM_DVFS_LEVEL_NR		(24)
#define ARM_ASV_GRP_NR			(16)
#define ARM_MAX_VOLT			(1300000)
#define KFC_DVFS_LEVEL_NR		(19)
#define KFC_ASV_GRP_NR			(16)
#define KFC_MAX_VOLT			(1225000)
#define G3D_DVFS_LEVEL_NR		(7)
#define G3D_ASV_GRP_NR			(16)
#define G3D_MAX_VOLT			(1150000)
#define MIF_DVFS_LEVEL_NR		(11)
#define MIF_ASV_GRP_NR			(16)
#define MIF_MAX_VOLT			(1050000)
#define INT_DVFS_LEVEL_NR		(8)
#define INT_ASV_GRP_NR			(16)
#define INT_MAX_VOLT			(1175000)
#define ISP_DVFS_LEVEL_NR		(7)
#define ISP_ASV_GRP_NR			(16)
#define ISP_MAX_VOLT			(1000000)

/* ASV_V00 */
static unsigned int arm_asv_volt_info[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2500000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1175000, 1150000},
	{ 2400000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1175000, 1150000},
	{ 2300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1162500, 1137500},
	{ 2200000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1137500, 1112500},
	{ 2100000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1112500, 1087500},
	{ 2000000, 1300000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1087500, 1062500},
	{ 1900000, 1300000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1062500, 1037500},
	{ 1800000, 1300000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1037500, 1012500},
	{ 1700000, 1275000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1012500,  987500},
	{ 1600000, 1250000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500,  987500,  962500},
	{ 1500000, 1225000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  962500,  937500},
	{ 1400000, 1187500, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  937500,  912500},
	{ 1300000, 1150000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  912500,  887500},
	{ 1200000, 1125000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  875000,  850000},
	{ 1100000, 1100000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  850000,  850000},
	{ 1000000, 1075000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000},
	{  900000, 1050000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000},
	{  800000, 1025000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  700000, 1025000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  600000, 1000000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  500000, 1000000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  400000,  975000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  300000,  925000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  200000,  925000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int kfc_asv_volt_info[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 2000000, 1300000, 1300000, 1300000, 1300000, 1300000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1137500, 1112500},
	{ 1900000, 1300000, 1300000, 1300000, 1300000, 1300000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1112500, 1087500},
	{ 1800000, 1300000, 1300000, 1287500, 1275000, 1262500, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1087500, 1062500},
	{ 1700000, 1275000, 1262500, 1250000, 1237500, 1225000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1062500, 1037500},
	{ 1600000, 1237500, 1225000, 1212500, 1200000, 1187500, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1037500, 1012500},
	{ 1500000, 1225000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1012500, 1000000},
	{ 1400000, 1187500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  975000,  975000},
	{ 1300000, 1150000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  937500,  937500},
	{ 1200000, 1112500, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  912500,  912500},
	{ 1100000, 1075000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  875000,  875000},
	{ 1000000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  850000,  850000},
	{  900000, 1000000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  800000,  975000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000},
	{  700000,  950000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  837500,  825000,  812500,  800000},
	{  600000,  925000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  837500,  825000,  812500,  800000,  787500,  775000},
	{  500000,  925000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  837500,  825000,  812500,  800000,  787500,  750000},
	{  400000,  925000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  837500,  825000,  812500,  800000,  787500,  750000},
	{  300000,  925000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  837500,  825000,  812500,  800000,  787500,  750000},
	{  200000,  925000,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  837500,  825000,  812500,  800000,  787500,  750000},
};

static unsigned int g3d_asv_volt_info[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  600000, 1150000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  925000,  912500},
	{  550000, 1125000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  887500,  875000},
	{  500000, 1075000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  850000,  850000},
	{  420000, 1025000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  350000, 1025000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  800000},
	{  266000, 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  775000},
	{  160000, 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  750000},
};

static unsigned int mif_asv_volt_info[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{ 1066000, 1150000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000},
	{  933000, 1100000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000},
	{  825000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  633000, 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000},
	{  543000,  975000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  775000},
	{  413000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  750000},
	{  275000,  950000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  750000},
	{  206000,  950000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  750000},
	{  165000,  925000,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  750000},
	{  138000,  900000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  750000},
	{  103000,  875000,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  750000},
};

static unsigned int int_asv_volt_info[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{  543000, 1175000, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  975000,  950000},
	{  400000, 1075000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000},
	{  317000, 1025000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  267000, 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000},
	{  200000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500},
	{  160000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000},
	{  133000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  100000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000},
};

static unsigned int isp_asv_volt_info[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{  777000,  950000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  666000,  950000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  555000,  950000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  444000,  950000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  333000,  950000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  222000,  925000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000},
	{  111000,  925000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  750000},
};

/* ASV_V01 */
static unsigned int arm_asv_volt_info_v01[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2500000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000},
	{ 2400000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000},
	{ 2300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1287500},
	{ 2200000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500},
	{ 2100000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 2000000, 1300000, 1300000, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500},
	{ 1900000, 1287500, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500},
	{ 1800000, 1237500, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500},
	{ 1700000, 1200000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000},
	{ 1600000, 1162500, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500},
	{ 1500000, 1137500, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500},
	{ 1400000, 1112500, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500},
	{ 1300000, 1087500, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  925000,  912500,  912500},
	{ 1200000, 1062500, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000,  912500,  912500},
	{ 1100000, 1037500, 1012500, 1000000,  987500,  975000,  962500,  950000,  950000,  937500,  925000,  925000,  925000,  925000,  925000,  912500,  912500},
	{ 1000000, 1000000,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  912500,  912500,  912500,  912500,  912500,  912500,  900000,  900000},
	{  900000,  962500,  937500,  925000,  925000,  925000,  925000,  912500,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  800000,  937500,  912500,  912500,  912500,  912500,  912500,  900000,  900000,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
	{  700000,  937500,  912500,  912500,  912500,  912500,  912500,  900000,  900000,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
	{  600000,  925000,  900000,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000,  875000,  875000,  875000,  875000,  875000},
	{  500000,  925000,  900000,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000,  875000,  875000,  875000,  875000,  875000},
	{  400000,  925000,  900000,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000,  875000,  875000,  875000,  875000,  875000},
	{  300000,  925000,  900000,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000,  875000,  875000,  875000,  875000,  875000},
	{  200000,  925000,  900000,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000,  875000,  875000,  875000,  875000,  875000},
};

static unsigned int kfc_asv_volt_info_v01[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 2000000, 1300000, 1287500, 1275000, 1262500, 1250000, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1125000, 1100000},
	{ 1900000, 1300000, 1287500, 1275000, 1262500, 1250000, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1125000, 1100000},
	{ 1800000, 1300000, 1287500, 1275000, 1262500, 1250000, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1125000, 1100000},
	{ 1700000, 1300000, 1287500, 1275000, 1262500, 1250000, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1100000, 1075000},
	{ 1600000, 1275000, 1262500, 1250000, 1237500, 1225000, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1075000, 1050000},
	{ 1500000, 1275000, 1250000, 1225000, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1050000, 1025000},
	{ 1400000, 1225000, 1200000, 1175000, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500,  987500},
	{ 1300000, 1175000, 1150000, 1125000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  975000,  950000},
	{ 1200000, 1137500, 1112500, 1087500, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  912500},
	{ 1100000, 1100000, 1075000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  875000},
	{ 1000000, 1075000, 1050000, 1025000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  900000, 1050000, 1025000, 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  800000, 1025000, 1000000,  975000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  825000,  812500},
	{  700000, 1000000,  975000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000},
	{  600000,  975000,  950000,  925000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  775000,  775000},
	{  500000,  950000,  925000,  900000,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000},
	{  400000,  925000,  900000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000},
	{  300000,  900000,  875000,  850000,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000},
	{  200000,  875000,  850000,  825000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000,  700000,  700000},
};

static unsigned int g3d_asv_volt_info_v01[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  600000, 1000000,  987500,  975000,  962500,  950000,  937500,  931250,  925000,  918750,  912500,  906250,  900000,  887500,  875000,  862500,  850000},
	{  550000,  950000,  937500,  925000,  912500,  900000,  887500,  881250,  875000,  868750,  862500,  856250,  850000,  837500,  825000,  812500,  800000},
	{  500000,  925000,  912500,  900000,  887500,  875000,  862500,  856250,  850000,  843750,  837500,  831250,  825000,  812500,  800000,  787500,  775000},
	{  420000,  912500,  900000,  887500,  875000,  862500,  850000,  843750,  837500,  831250,  825000,  818750,  812500,  800000,  787500,  775000,  762500},
	{  350000,  900000,  887500,  875000,  862500,  850000,  837500,  831250,  825000,  818750,  812500,  806250,  800000,  787500,  775000,  762500,  750000},
	{  266000,  887500,  875000,  862500,  850000,  837500,  825000,  818750,  812500,  806250,  800000,  793750,  787500,  775000,  762500,  750000,  737500},
	{  160000,  887500,  875000,  862500,  850000,  837500,  825000,  818750,  812500,  806250,  800000,  793750,  787500,  775000,  762500,  750000,  737500},
};

static unsigned int mif_asv_volt_info_v01[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{ 1066000, 1125000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000},
	{  933000, 1075000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000},
	{  825000, 1025000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000},
	{  633000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000},
	{  543000,  925000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  712500},
	{  413000,  900000,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  700000,  700000,  700000},
	{  275000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000},
	{  206000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000},
	{  165000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000},
	{  138000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000},
	{  103000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000},
};

static unsigned int int_asv_volt_info_v01[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{  543000, 1025000, 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500},
	{  400000,  975000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  317000,  950000,  925000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500},
	{  267000,  925000,  900000,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500},
	{  200000,  900000,  875000,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000},
	{  160000,  875000,  850000,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000,  700000},
	{  133000,  875000,  850000,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000,  700000},
	{  100000,  875000,  850000,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000,  700000},
};

static unsigned int isp_asv_volt_info_v01[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{  777000,  975000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  666000,  975000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  555000,  975000,  950000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  444000,  950000,  925000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500},
	{  333000,  950000,  925000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500},
	{  222000,  875000,  850000,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000,  700000},
	{  111000,  875000,  850000,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  712500,  700000,  700000,  700000,  700000},
};

#endif /* EXYNOS5430_ASV_H */
