/* linux/drivers/media/video/exynos/fimg2d/fimg2d4x_regs.h
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd.
 *	http://www.samsung.com/
 *
 * Register Definitions for Samsung Graphics 2D Hardware
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __FIMG2D4X_REGS_H
#define __FIMG2D4x_REGS_H __FILE__

/* Macros */
#define FIMG2D_ADDR(v)		((v) << 0)
#define FIMG2D_STRIDE(v)	(((v) & (0xffff)) << 0)
#define FIMG2D_OFFSET(x, y)	((((y) & 0x1fff) << 16) | (((x) & 0x1fff) << 0))
#define FIMG2D_SIZE(w, h)	((((h) & 0x1fff) << 16) | (((w) & 0x1fff) << 0))
#define FIMG2D_COLOR(v)		((v) << 0)

/* Registers */
#define FIMG2D_SOFT_RESET_REG			(0x000)
#define FIMG2D_INTEN_REG			(0x004)
#define FIMG2D_INTC_PEND_REG			(0x00c)
#define FIMG2D_FIFO_STAT_REG			(0x010)
#define FIMG2D_AXI_MODE_REG			(0x01c)
#define FIMG2D_DMA_SFR_BASE_ADDR_REG		(0x080)
#define FIMG2D_DMA_COMMAND_REG			(0x084)
#define FIMG2D_DMA_EXE_LIST_NUM_REG		(0x088)
#define FIMG2D_DMA_STATUS_REG			(0x08c)
#define FIMG2D_DMA_HOLD_CMD_REG			(0x090)
#define FIMG2D_BITBLT_START_REG			(0x100)
#define FIMG2D_BITBLT_COMMAND_REG		(0x104)
#define FIMG2D_BLEND_FUNCTION_REG		(0x108)
#define FIMG2D_ROUND_MODE_REG			(0x10c)
#define FIMG2D_ROTATE_REG			(0x200)
#define FIMG2D_SRC_MSK_DIRECT_REG		(0x204)
#define FIMG2D_DST_PAT_DIRECT_REG		(0x208)
#define FIMG2D_SRC_SELECT_REG			(0x300)
#define FIMG2D_SRC_BASE_ADDR_REG		(0x304)
#define FIMG2D_SRC_STRIDE_REG			(0x308)
#define FIMG2D_SRC_COLOR_MODE_REG		(0x30c)
#define FIMG2D_SRC_LEFT_TOP_REG			(0x310)
#define FIMG2D_SRC_RIGHT_BOTTOM_REG		(0x314)
#define FIMG2D_SRC_PLANE2_BASE_ADDR_REG		(0x318)
#define FIMG2D_SRC_REPEAT_MODE_REG		(0x31c)
#define FIMG2D_SRC_PAD_VALUE_REG		(0x320)
#define FIMG2D_SRC_A8_RGB_EXT_REG		(0x324)
#define FIMG2D_SRC_SCALE_CTRL_REG		(0x328)
#define FIMG2D_SRC_XSCALE_REG			(0x32c)
#define FIMG2D_SRC_YSCALE_REG			(0x330)
#define FIMG2D_DST_SELECT_REG			(0x400)
#define FIMG2D_DST_BASE_ADDR_REG		(0x404)
#define FIMG2D_DST_STRIDE_REG			(0x408)
#define FIMG2D_DST_COLOR_MODE_REG		(0x40c)
#define FIMG2D_DST_LEFT_TOP_REG			(0x410)
#define FIMG2D_DST_RIGHT_BOTTOM_REG		(0x414)
#define FIMG2D_DST_PLANE2_BASE_ADDR_REG		(0x418)
#define FIMG2D_DST_A8_RGB_EXT_REG		(0x41c)
#define FIMG2D_PAT_BASE_ADDR_REG		(0x500)
#define FIMG2D_PAT_SIZE_REG			(0x504)
#define FIMG2D_PAT_COLOR_MODE_REG		(0x508)
#define FIMG2D_PAT_OFFSET_REG			(0x50c)
#define FIMG2D_PAT_STRIDE_REG			(0x510)
#define FIMG2D_MSK_BASE_ADDR_REG		(0x520)
#define FIMG2D_MSK_STRIDE_REG			(0x524)
#define FIMG2D_MSK_LEFT_TOP_REG			(0x528)
#define FIMG2D_MSK_RIGHT_BOTTOM_REG		(0x52c)
#define FIMG2D_MSK_MODE_REG			(0x530)
#define FIMG2D_MSK_REPEAT_MODE_REG		(0x534)
#define FIMG2D_MSK_PAD_VALUE_REG		(0x538)
#define FIMG2D_MSK_SCALE_CTRL_REG		(0x53c)
#define FIMG2D_MSK_XSCALE_REG			(0x540)
#define FIMG2D_MSK_YSCALE_REG			(0x544)
#define FIMG2D_CW_LT_REG			(0x600)
#define FIMG2D_CW_RB_REG			(0x604)
#define FIMG2D_THIRD_OPERAND_REG		(0x610)
#define FIMG2D_ROP4_REG				(0x614)
#define FIMG2D_ALPHA_REG			(0x618)
#define FIMG2D_FG_COLOR_REG			(0x700)
#define FIMG2D_BG_COLOR_REG			(0x704)
#define FIMG2D_BS_COLOR_REG			(0x708)
#define FIMG2D_SF_COLOR_REG			(0x70c)
#define FIMG2D_SRC_COLORKEY_CTRL_REG		(0x710)
#define FIMG2D_SRC_COLORKEY_DR_MIN_REG		(0x714)
#define FIMG2D_SRC_COLORKEY_DR_MAX_REG		(0x718)
#define FIMG2D_DST_COLORKEY_CTRL_REG		(0x71c)
#define FIMG2D_DST_COLORKEY_DR_MIN_REG		(0x720)
#define FIMG2D_DST_COLORKEY_DR_MAX_REG		(0x724)
#define FIMG2D_YCBCR_SRC_COLORKEY_CTRL_REG	(0x728)
#define FIMG2D_YCBCR_SRC_COLORKEY_DR_MIN_REG	(0x72c)
#define FIMG2D_YCBCR_SRC_COLORKEY_DR_MAX_REG	(0x730)
#define FIMG2D_YCBCR_DST_COLORKEY_CTRL_REG	(0x734)
#define FIMG2D_YCBCR_DST_COLORKEY_DR_MIN_REG	(0x738)
#define FIMG2D_YCBCR_DST_COLORKEY_DR_MAX_REG	(0x73c)
#define FIMG2D_GAMMA_TABLE0_0_REG		(0x800)
#define FIMG2D_GAMMA_TABLE0_1_REG		(0x804)
#define FIMG2D_GAMMA_TABLE0_2_REG		(0x808)
#define FIMG2D_GAMMA_TABLE0_3_REG		(0x80c)
#define FIMG2D_GAMMA_TABLE0_4_REG		(0x810)
#define FIMG2D_GAMMA_TABLE0_5_REG		(0x814)
#define FIMG2D_GAMMA_TABLE0_6_REG		(0x818)
#define FIMG2D_GAMMA_TABLE0_7_REG		(0x81c)
#define FIMG2D_GAMMA_TABLE0_8_REG		(0x820)
#define FIMG2D_GAMMA_TABLE0_9_REG		(0x824)
#define FIMG2D_GAMMA_TABLE0_10_REG		(0x828)
#define FIMG2D_GAMMA_TABLE0_11_REG		(0x82c)
#define FIMG2D_GAMMA_TABLE0_12_REG		(0x830)
#define FIMG2D_GAMMA_TABLE0_13_REG		(0x834)
#define FIMG2D_GAMMA_TABLE0_14_REG		(0x838)
#define FIMG2D_GAMMA_TABLE0_15_REG		(0x83c)
#define FIMG2D_GAMMA_TABLE1_0_REG		(0x840)
#define FIMG2D_GAMMA_TABLE1_1_REG		(0x844)
#define FIMG2D_GAMMA_TABLE1_2_REG		(0x848)
#define FIMG2D_GAMMA_TABLE1_3_REG		(0x84c)
#define FIMG2D_GAMMA_TABLE1_4_REG		(0x850)
#define FIMG2D_GAMMA_TABLE1_5_REG		(0x854)
#define FIMG2D_GAMMA_TABLE1_6_REG		(0x858)
#define FIMG2D_GAMMA_TABLE1_7_REG		(0x85c)
#define FIMG2D_GAMMA_TABLE1_8_REG		(0x860)
#define FIMG2D_GAMMA_TABLE1_9_REG		(0x864)
#define FIMG2D_GAMMA_TABLE1_10_REG		(0x868)
#define FIMG2D_GAMMA_TABLE1_11_REG		(0x86c)
#define FIMG2D_GAMMA_TABLE1_12_REG		(0x870)
#define FIMG2D_GAMMA_TABLE1_13_REG		(0x874)
#define FIMG2D_GAMMA_TABLE1_14_REG		(0x878)
#define FIMG2D_GAMMA_TABLE1_15_REG		(0x87c)
#define FIMG2D_GAMMA_REF_COLOR_REG		(0x880)

/* Bit Definitions */

/* FIMG2D_SOFT_RESET_REG */
#define FIMG2D_SFR_CLEAR			(1 << 1)
#define FIMG2D_SOFT_RESET			(1 << 0)

/* FIMG2D_INTEN_REG */
#define FIMG2D_INT_TYPE_EDGE			(1 << 4)
#define FIMG2D_INT_TYPE_LEVEL			(0 << 4)

#define FIMG2D_ACF_INT_ENABLE			(1 << 3)
#define FIMG2D_UCF_INT_ENABLE			(1 << 2)
#define FIMG2D_GCF_INT_ENABLE			(1 << 1)
#define FIMG2D_BLIT_INT_ENABLE			(1 << 0)

/* FIMG2D_INTC_PEND_REG */
#define FIMG2D_ACMD_INT_FLAG			(1 << 3)
#define FIMG2D_UCMD_INT_FLAG			(1 << 2)
#define FIMG2D_GCMD_INT_FLAG			(1 << 1)
#define FIMG2D_BLIT_INT_FLAG			(1 << 0)

/* FIMG2D_FIFO_STAT_REG */
#define FIMG2D_BLIT_FINISHED			(1 << 0)

/* FIMG2D_AXI_MODE_REG */
#define FIMG2D_MAX_BURST_LEN_2			(0 << 24)
#define FIMG2D_MAX_BURST_LEN_4			(1 << 24)
#define FIMG2D_MAX_BURST_LEN_8			(2 << 24)
#define FIMG2D_MAX_BURST_LEN_16			(3 << 24)
#define FIMG2D_MAX_BURST_LEN_MASK		(3 << 24)
#define FIMG2D_MAX_BURST_LEN_SHIFT		(24)

#define FIMG2D_AXI_AWUSERS_SHIFT		(16)
#define FIMG2D_AXI_ARUSERS_SHIFT		(8)
#define FIMG2D_AXI_AWCACHE_SHIFT		(4)
#define FIMG2D_AXI_ARCACHE_SHIFT		(0)

/* FIMG2D_DMA_SFR_BASE_ADDR_REG */

/* FIMG2D_DMA_COMMAND_REG */
#define FIMG2D_BATCH_BLIT_HALT			(1 << 2)
#define FIMG2D_BATCH_BLIT_CONT			(1 << 1)
#define FIMG2D_BATCH_BLIT_START			(1 << 0)

/* FIMG2D_DMA_EXE_LIST_NUM_REG */
#define FIMG2D_BATCH_BLIT_EXELIST_NUM_MASK	(0xff)
#define FIMG2D_BATCH_BLIT_EXELIST_NUM_SHIFT	(0)

/* FIMG2D_DMA_STATUS_REG */
#define FIMG2D_BATCH_BLIT_DONELIST_CNT_MASK	(0xff)
#define FIMG2D_BATCH_BLIT_DONELIST_CNT_SHIFT	(17)

#define FIMG2D_BATCH_BLIT_DONEBLIT_CNT_MASK	(0xffff)
#define FIMG2D_BATCH_BLIT_DONEBLIT_CNT_SHIFT	(1)

#define FIMG2D_BATCH_BLIT_DONE_MASK		(1)
#define FIMG2D_BATCH_BLIT_DONE_SHIFT		(0)

/* FIMG2D_DMA_HOLD_CMD_REG */
#define FIMG2D_BATCH_BLIT_USER_HOLD		(1 << 2)
#define FIMG2D_BATCH_BLIT_LIST_HOLD		(1 << 1)
#define FIMG2D_BATCH_BLIT_BLIT_HOLD		(1 << 0)

/* FIMG2D_BITBLT_START_REG */
#define FIMG2D_START_N_HOLD			(1 << 1)
#define FIMG2D_START_BITBLT			(1 << 0)

/* FIMG2D_BITBLT_COMMAND_REG */
#define FIMG2D_SOLID_FILL			(1 << 28)

#define FIMG2D_DST_WR_DEPREMULT			(1 << 27)
#define FIMG2D_DST_RD_PREMULT			(1 << 26)
#define FIMG2D_PAT_PREMULT			(1 << 25)
#define FIMG2D_SRC_PREMULT			(1 << 24)
#define FIMG2D_PREMULT_ALL			(0xf << 24)

#define FIMG2D_ALPHA_BLEND_MODE			(1 << 20)

#define FIMG2D_COLORKEY_SRC_RGBA		(1 << 16)
#define FIMG2D_COLORKEY_DST_RGBA		(2 << 16)
#define FIMG2D_COLORKEY_SRC_YCBCR		(4 << 16)
#define FIMG2D_COLORKEY_DST_YCBCR		(8 << 16)

#define FIMG2D_OPAQUE_MODE			(0 << 12)
#define FIMG2D_TRANSP_MODE			(1 << 12)
#define FIMG2D_BLUSCR_MODE			(2 << 12)

#define FIMG2D_ENABLE_CW			(1 << 8)
#define FIMG2D_ENABLE_DITHER			(1 << 3)

#define FIMG2D_ENABLE_SRC_ALPHA			(0 << 2)
#define FIMG2D_ENABLE_ROP_ALPHA			(1 << 2)

#define FIMG2D_ENABLE_ROP4_MSK			(1 << 0)
#define FIMG2D_ENABLE_NORMAL_MSK		(2 << 0)

/* FIMG2D_BLEND_FUNCTION_REG */
#define FIMG2D_WINCE_SRC_OVER			(1 << 22)
#define FIMG2D_DARKEN				(1 << 21)
#define FIMG2D_LIGHTEN				(1 << 20)
#define FIMG2D_INV_DST_COEFF			(1 << 18)
#define FIMG2D_INV_SRC_COEFF			(1 << 16)

#define FIMG2D_DST_COEFF_DA_SHIFT		(14)
#define FIMG2D_DST_COEFF_SA_SHIFT		(12)
#define FIMG2D_SRC_COEFF_DA_SHIFT		(6)
#define FIMG2D_SRC_COEFF_SA_SHIFT		(4)

#define FIMG2D_DST_COEFF_SHIFT			(8)
#define FIMG2D_SRC_COEFF_SHIFT			(0)

/* FIMG2D_ROUND_MODE_REG */
#define FIMG2D_PREMULT_ROUND_MASK		(3 << 4)
#define FIMG2D_PREMULT_ROUND_SHIFT		(4)

#define FIMG2D_BLEND_ROUND_MASK			(3 << 0)
#define FIMG2D_BLEND_ROUND_SHIFT		(0)

/* FIMG2D_ROTATE_REG */
#define FIMG2D_MSK_ROTATE_90			(1 << 8)
#define FIMG2D_PAT_ROTATE_90			(1 << 4)
#define FIMG2D_SRC_ROTATE_90			(1 << 0)

/* FIMG2D_SRC_MSK_DIRECT_REG */
#define FIMG2D_MSK_Y_DIR_NEGATIVE		(1 << 5)
#define FIMG2D_MSK_X_DIR_NEGATIVE		(1 << 4)

#define FIMG2D_SRC_Y_DIR_NEGATIVE		(1 << 1)
#define FIMG2D_SRC_X_DIR_NEGATIVE		(1 << 0)

/* FIMG2D_DST_PAT_DIRECT_REG */
#define FIMG2D_PAT_Y_DIR_NEGATIVE		(1 << 5)
#define FIMG2D_PAT_X_DIR_NEGATIVE		(1 << 4)

#define FIMG2D_DST_Y_DIR_NEGATIVE		(1 << 1)
#define FIMG2D_DST_X_DIR_NEGATIVE		(1 << 0)

/* FIMG2D_SRC_SELECT_REG & FIMG2D_DST_SELECT_REG */
#define FIMG2D_IMAGE_TYPE_MEMORY		(0 << 0)
#define FIMG2D_IMAGE_TYPE_FGCOLOR		(1 << 0)
#define FIMG2D_IMAGE_TYPE_BGCOLOR		(2 << 0)

/* FIMG2D_SRC_BASE_ADDR_REG */
/* FIMG2D_DST_BASE_ADDR_REG */
/* FIMG2D_PAT_BASE_ADDR_REG */
/* FIMG2D_MSK_BASE_ADDR_REG */

/* FIMG2D_SRC_STRIDE_REG */
/* FIMG2D_DST_STRIDE_REG */
/* FIMG2D_PAT_STRIDE_REG */
/* FIMG2D_MSK_STRIDE_REG */

/* FIMG2D_SRC_COLOR_MODE_REG & FIMG2D_DST_COLOR_MODE_REG */
#define FIMG2D_YCBCR_NARROW			(0 << 17)
#define FIMG2D_YCBCR_WIDE			(1 << 17)

#define FIMG2D_CSC_601				(0 << 16)
#define FIMG2D_CSC_709				(1 << 16)

#define FIMG2D_YCBCR_ORDER_P1_CRY1CBY0		(0 << 12)
#define FIMG2D_YCBCR_ORDER_P1_CBY1CRY0		(0 << 12)
#define FIMG2D_YCBCR_ORDER_P1_Y1CRY0CB		(0 << 12)
#define FIMG2D_YCBCR_ORDER_P1_Y1CBY0CR		(0 << 12)
#define FIMG2D_YCBCR_ORDER_P2_CRCB		(0 << 12)
#define FIMG2D_YCBCR_ORDER_P2_CBCR		(1 << 12)
#define FIMG2D_YCBCR_ORDER_SHIFT		(12)

#define FIMG2D_YCBCR_1PLANE			(0 << 8)
#define FIMG2D_YCBCR_2PLANE			(1 << 8)

#define FIMG2D_RGB_ORDER_AXRGB			(0 << 4)
#define FIMG2D_RGB_ORDER_RGBAX			(1 << 4)
#define FIMG2D_RGB_ORDER_AXBGR			(2 << 4)
#define FIMG2D_RGB_ORDER_BGRAX			(3 << 4)
#define FIMG2D_RGB_ORDER_SHIFT			(4)

#define FIMG2D_COLOR_FORMAT_XRGB_8888		(0 << 0)
#define FIMG2D_COLOR_FORMAT_ARGB_8888		(1 << 0)
#define FIMG2D_COLOR_FORMAT_RGB_565		(2 << 0)
#define FIMG2D_COLOR_FORMAT_XRGB_1555		(3 << 0)
#define FIMG2D_COLOR_FORMAT_ARGB_1555		(4 << 0)
#define FIMG2D_COLOR_FORMAT_XRGB_4444		(5 << 0)
#define FIMG2D_COLOR_FORMAT_ARGB_4444		(6 << 0)
#define FIMG2D_COLOR_FORMAT_PACKED_RGB_888	(7 << 0)
#define FIMG2D_COLOR_FORMAT_YCBCR_444		(8 << 0)
#define FIMG2D_COLOR_FORMAT_YCBCR_422		(9 << 0)
#define FIMG2D_COLOR_FORMAT_YCBCR_420		(10 << 0)
#define FIMG2D_COLOR_FORMAT_A8			(11 << 0)
#define FIMG2D_COLOR_FORMAT_L8			(12 << 0)
#define FIMG2D_COLOR_FORMAT_SHIFT		(0)

/* FIMG2D_PAT_COLOR_MODE_REG */
#define FIMG2D_PAT_ORDER_AXRGB			(0 << 4)
#define FIMG2D_PAT_ORDER_RGBAX			(1 << 4)
#define FIMG2D_PAT_ORDER_AXBGR			(2 << 4)
#define FIMG2D_PAT_ORDER_BGRAX			(3 << 4)

#define FIMG2D_PAT_FORMAT_XRGB_8888		(0 << 0)
#define FIMG2D_PAT_FORMAT_ARGB_8888		(1 << 0)
#define FIMG2D_PAT_FORMAT_RGB_565		(2 << 0)
#define FIMG2D_PAT_FORMAT_XRGB_1555		(3 << 0)
#define FIMG2D_PAT_FORMAT_ARGB_1555		(4 << 0)
#define FIMG2D_PAT_FORMAT_XRGB_4444		(5 << 0)
#define FIMG2D_PAT_FORMAT_ARGB_4444		(6 << 0)
#define FIMG2D_PAT_FORMAT_PACKED_RGB_888	(7 << 0)

/* FIMG2D_SRC_LEFT_TOP_REG & FIMG2D_SRC_RIGHT_BOTTOM_REG */
/* FIMG2D_DST_LEFT_TOP_REG & FIMG2D_DST_RIGHT_BOTTOM_REG */
/* FIMG2D_MSK_LEFT_TOP_REG & FIMG2D_MSK_RIGHT_BOTTOM_REG */
#define FIMG2D_COORD_LT_Y_SHIFT			(16)
#define FIMG2D_COORD_LT_X_SHIFT			(0)
#define FIMG2D_COORD_RB_Y_SHIFT			(16)
#define FIMG2D_COORD_RB_X_SHIFT			(0)
#define FIMG2D_COORD_MAX_HEIGHT			(8000)
#define FIMG2D_COORD_MAX_WIDTH			(8000)

/* FIMG2D_SRC_PLANE2_BASE_ADDR_REG */
/* FIMG2D_DST_PLANE2_BASE_ADDR_REG */

/* FIMG2D_SRC_REPEAT_MODE_REG */
#define FIMG2D_SRC_REPEAT_NORMAL		(0 << 0)
#define FIMG2D_SRC_REPEAT_PAD			(1 << 0)
#define FIMG2D_SRC_REPEAT_REFLECT		(2 << 0)
#define FIMG2D_SRC_REPEAT_CLAMP			(3 << 0)
#define FIMG2D_SRC_REPEAT_NONE			(4 << 0)
#define FIMG2D_SRC_REPEAT_SHIFT			(0)

/* FIMG2D_MSK_REPEAT_MODE_REG */
#define FIMG2D_MSK_REPEAT_NORMAL		(0 << 0)
#define FIMG2D_MSK_REPEAT_PAD			(1 << 0)
#define FIMG2D_MSK_REPEAT_REFLECT		(2 << 0)
#define FIMG2D_MSK_REPEAT_CLAMP			(3 << 0)
#define FIMG2D_MSK_REPEAT_SHIFT			(0)

/* FIMG2D_SRC_PAD_VALUE_REG */
/* FIMG2D_MSK_PAD_VALUE_REG */

/* FIMG2D_SRC_A8_RGB_EXT_REG */
/* FIMG2D_DST_A8_RGB_EXT_REG */

/* FIMG2D_SRC_SCALE_CTRL_REG & FIMG2D_MSK_SCALE_CTRL_REG */
#define FIMG2D_SCALE_MODE_NEAREST		(1 << 0)
#define FIMG2D_SCALE_MODE_BILINEAR		(2 << 0)

/* FIMG2D_SRC_XSCALE_REG & FIMG2D_SRC_YSCALE_REG */
/* FIMG2D_MSK_XSCALE_REG & FIMG2D_MSK_YSCALE_REG */
#define FIMG2D_SCALE_FACTOR_INTG_SHIFT		(16)
#define FIMG2D_SCALE_FACTOR_FRAC_SHIFT		(0)

/* FIMG2D_PAT_SIZE_REG */
#define FIMG2D_PAT_HEIGHT_SHIFT			(16)
#define FIMG2D_PAT_WIDTH_SHIFT			(0)
#define FIMG2D_MAX_PAT_HEIGHT			(8000)
#define FIMG2D_MAX_PAT_WIDTH			(8000)

/* FIMG2D_PAT_OFFSET_REG */
#define FIMG2D_PAT_Y_OFFSET_SHIFT		(16)
#define FIMG2D_PAT_X_OFFSET_SHIFT		(0)
#define FIMG2D_MAX_PAT_Y_OFFSET			(7999)
#define FIMG2D_MAX_PAT_X_OFFSET			(7999)

/* FIMG2D_MSK_MODE_REG */
#define FIMG2D_MSK_TYPE_ALPHA			(0 << 8)
#define FIMG2D_MSK_TYPE_ARGB			(1 << 8)
#define FIMG2D_MSK_TYPE_MIXED			(2 << 8)

#define FIMG2D_MSK_ORDER_AXRGB			(0 << 4)
#define FIMG2D_MSK_ORDER_RGBAX			(1 << 4)
#define FIMG2D_MSK_ORDER_AXBGR			(2 << 4)
#define FIMG2D_MSK_ORDER_BGRAX			(3 << 4)
#define FIMG2D_MSK_ORDER_SHIFT			(4)

#define FIMG2D_1BIT_MSK				(0 << 0)
#define FIMG2D_4BIT_MSK				(1 << 0)
#define FIMG2D_8BIT_MSK				(2 << 0)
#define FIMG2D_16BIT_MSK_565			(3 << 0)
#define FIMG2D_16BIT_MSK_1555			(4 << 0)
#define FIMG2D_16BIT_MSK_4444			(5 << 0)
#define FIMG2D_32BIT_MSK_8888			(6 << 0)
#define FIMG2D_4BIT_MSK_WINCE_AA_FONT		(7 << 0)
#define FIMG2D_MSK_FORMAT_SHIFT			(0)

/* FIMG2D_CW_LT_REG */
#define FIMG2D_CW_COORD_LT_Y_SHIFT		(16)
#define FIMG2D_CW_COORD_LT_X_SHIFT		(0)
#define FIMG2D_CW_COORD_RB_Y_SHIFT		(16)
#define FIMG2D_CW_COORD_RB_X_SHIFT		(0)

/* FIMG2D_THIRD_OPERAND_REG */
#define FIMG2D_OPR3_MSKSEL_PAT			(0 << 4)
#define FIMG2D_OPR3_MSKSEL_FGCOLOR		(1 << 4)
#define FIMG2D_OPR3_MSKSEL_BGCOLOR		(2 << 4)
#define FIMG2D_OPR3_UNMSKSEL_PAT		(0 << 0)
#define FIMG2D_OPR3_UNMSKSEL_FGCOLOR		(1 << 0)
#define FIMG2D_OPR3_UNMSKSEL_BGCOLOR		(2 << 0)

/* FIMG2D_ROP4_REG */
#define FIMG2D_MASKED_ROP3_SHIFT		(8)
#define FIMG2D_UNMASKED_ROP3_SHIFT		(0)

/* FIMG2D_ALPHA_REG */
#define FIMG2D_GCOLOR_RGB_MASK			(0xffffff)
#define FIMG2D_GCOLOR_SHIFT			(8)

#define FIMG2D_GALPHA_MASK			(0xff)
#define FIMG2D_GALPHA_SHIFT			(0)

/* FIMG2D_FG_COLOR_REG */
/* FIMG2D_BG_COLOR_REG */
/* FIMG2D_BS_COLOR_REG */
/* FIMG2D_SF_COLOR_REG */

/* FIMG2D_SRC_COLORKEY_CTRL_REG */
/* FIMG2D_SRC_COLORKEY_DR_MIN_REG */
/* FIMG2D_SRC_COLORKEY_DR_MAX_REG */

/* FIMG2D_DST_COLORKEY_CTRL_REG */
/* FIMG2D_DST_COLORKEY_DR_MIN_REG */
/* FIMG2D_DST_COLORKEY_DR_MAX_REG */

/* FIMG2D_YCBCR_SRC_COLORKEY_CTRL_REG */
/* FIMG2D_YCBCR_SRC_COLORKEY_DR_MIN_REG */
/* FIMG2D_YCBCR_SRC_COLORKEY_DR_MAX_REG */

/* FIMG2D_YCBCR_DST_COLORKEY_CTRL_REG */
/* FIMG2D_YCBCR_DST_COLORKEY_DR_MIN_REG */
/* FIMG2D_YCBCR_DST_COLORKEY_DR_MAX_REG */

#endif /* __FIMG2D4X_REGS_H */
