/*
 * exynos-mipi-lli.h - Exynos MIPI-LLI Header
 *
 * Copyright (c) 2013 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DRIVERS_EXYNOS_MIPI_LLI_H
#define __DRIVERS_EXYNOS_MIPI_LLI_H

/* LLI Configuration System Register */
#define CPIF_USER_REG0				(0x0000)
#define CPIF_USER_REG1				(0x0004)
#define CPIF_USER_REG2				(0x0008)
#define CPIF_USER_REG3				(0x000C)
#define CPIF_USER_REG4				(0x0010)
#define CPIF_SFR_APB				(0x0010)
#define CPIF_NOC_RCG_EN				(0x0200)
#define CPIF_XIU_TOP_RCG_EN			(0x0204)
#define CPIF_AXI_US_RCG_EN			(0x0208)
#define CPIF_XIU_ASYNC_RCG_EN			(0x020C)
#define CPIF_EMA_RA1_HD_CON			(0x0300)
#define CPIF_EMA_RA1_HS_CON			(0x0304)
#define CPIF_EMA_RA2_HD_CON			(0x0308)
#define CPIF_EMA_RF1_HD_CON			(0x0310)
#define CPIF_EMA_RF1_HS_CON			(0x0314)
#define CPIF_EMA_RF2_HD_CON			(0x0318)
#define CPIF_EMA_RF2_HS_CON			(0x031C)
#define CPIF_EMA_CON				(0x0330)
#define CPIF_WRITE_ASSIST			(0x0400)
#define CPIF_LLI_SIG_IN0			(0x1000)
#define CPIF_LLI_SIG_IN1			(0x1004)
#define CPIF_LLI_SIG_OUT0			(0x1008)
#define CPIF_LLI_SIG_OUT1			(0x100C)
#define CPIF_LLI_DBG_SIG_OUT0			(0x1010)
#define CPIF_LLI_DBG_SIG_OUT1			(0x1014)
#define CPIF_LLI_SCRAMBLE			(0x1020)
#define CPIF_LLI_SIG_INT_MASK0			(0x1030)
#define CPIF_LLI_SIG_INT_MASK1			(0x1034)
#define CPIF_LLI_WAKEUP				(0x1038)
#define CPIF_LLI				(0x1040)

/* LLI PA Configuration Attributes */
#define EXYNOS_PA_TX_COUNT			(0x000)
#define EXYNOS_PA_RX_COUNT			(0x004)
#define EXYNOS_PA_MK0_INSERTION_ENABLE		(0x100)
#define EXYNOS_PA_WT_START_VALUE		(0x104)
#define EXYNOS_PA_PHIT_ERROR_COUNTER		(0x108)
#define EXYNOS_PA_PHIT_RECEIVE_COUNT_ENABLE	(0x10c)
#define EXYNOS_PA_PHIT_ERR_COUNT_ENABLE		(0x110)
#define EXYNOS_PA_PHIT_RECEIVE_COUNTER_LSB	(0x114)
#define EXYNOS_PA_PHIT_RECEIVE_COUNTER_MSB	(0x118)
#define EXYNOS_PA_PHIT_CLEAR_COUNTER		(0x11c)
#define EXYNOS_PA_ACTIVE_TX_COUNT		(0x120)
#define EXYNOS_PA_ACTIVE_RX_COUNT		(0x124)
#define EXYNOS_PA_CONFIG_UPDATE			(0x128)
#define EXYNOS_PA_MIN_SAVE_CONFIG		(0x12c)
#define EXYNOS_PA_WORSTCASE_RTT			(0x130)
#define EXYNOS_PA_DRIVE_TACTIVATE_DURATION	(0x134)
#define EXYNOS_PA_CSA_PA_STATUS			(0x138)
#define EXYNOS_PA_CSA_PA_SET			(0x13c)
#define EXYNOS_PA_CSA_PA_CLR			(0x140)
#define EXYNOS_PA_PHYTESTCONFIG			(0x148)
#define EXYNOS_PA_PHYTESTRESULT0		(0x14c)
#define EXYNOS_PA_PHYTESTRESULT1		(0x150)
#define EXYNOS_PA_PHYTESTRESULT2		(0x154)
#define EXYNOS_PA_PHYTESTRESULT3		(0x158)
#define EXYNOS_PA_PHYTESTRESULT4		(0x15C)
#define EXYNOS_PA_PHYTESTRESULT5		(0x160)
#define EXYNOS_PA_PHYTESTRESULT6		(0x164)
#define EXYNOS_PA_PHYTESTRESULT7		(0x168)
#define EXYNOS_PA_PHYTESTRESULT8		(0x16C)
#define EXYNOS_PA_PHYTESTRESULT9		(0x170)
#define EXYNOS_PA_PHYTESTRESULT10		(0x174)
#define EXYNOS_PA_PHYTESTRESULT11		(0x178)

/* LLI PA User Attributes */
#define EXYNOS_PA_SYSTEM_CLK_PERIOD		(0x400)
#define EXYNOS_PA_SLAVE_AUTOMOUNT		(0x404)
#define EXYNOS_PA_MK0_CONTROL			(0x408)
#define EXYNOS_PA_NACK_RTT			(0x40C)
#define EXYNOS_PA_RETRY_BUFFER_SIZE		(0x410)
#define EXYNOS_PA_SMART_BUFFER_ENABLE		(0x414)
#define EXYNOS_PA_MPHY_OV_TM_ENABLE		(0x418)
#define EXYNOS_PA_MPHY_CMN_ENABLE		(0x41C)
#define EXYNOS_PA_USR_SCRAMBLER_ENABLE		(0x420)
#define EXYNOS_PA_USR_SCRAMBLER_FLR_SEQUENCE	(0x424)

/* LLI PA Debug Attributes */
#define EXYNOS_PA_DBG_TACTIVATE_TIMEOUT_CNT	(0x500)
#define EXYNOS_PA_DBG_MOUNT_FAIL_THLD		(0x504)
#define EXYNOS_PA_DBG_SEQ_ERROR_INJECT		(0x508)
#define EXYNOS_PA_DBG_CRC_ERROR_INJECT		(0x50C)
#define EXYNOS_PA_DBG_CRC_ERROR_NACK_RTT	(0x510)
#define EXYNOS_PA_DBG_PA_SIGNAL_STATUS		(0x514)
#define EXYNOS_PA_DBG_RETRY_BUFFER_STATUS0	(0x518)
#define EXYNOS_PA_DBG_RETRY_BUFFER_STATUS1	(0x51C)
#define EXYNOS_PA_DBG_TEST_BURST_CNT0		(0x520)
#define EXYNOS_PA_DBG_TEST_BURST_CNT1		(0x524)
#define EXYNOS_PA_DBG_TEST_BURST_CNT2		(0x528)
#define EXYNOS_PA_DBG_TEST_BURST_CNT3		(0x52C)
#define EXYNOS_PA_DBG_TEST_BURST_CNT4		(0x530)
#define EXYNOS_PA_DBG_TEST_BURST_CNT5		(0x534)
#define EXYNOS_PA_DBG_TEST_BURST_CNT6		(0x538)
#define EXYNOS_PA_DBG_TEST_BURST_CNT7		(0x53C)
#define EXYNOS_PA_DBG_TEST_BURST_CNT8		(0x540)
#define EXYNOS_PA_DBG_TEST_BURST_CNT9		(0x544)
#define EXYNOS_PA_DBG_TEST_BURST_CNT10		(0x548)
#define EXYNOS_PA_DBG_TEST_BURST_CNT11		(0x54C)
#define EXYNOS_PA_DBG_FREEZE_STATE		(0x550)
#define EXYNOS_PA_DBG_RW_PA_STATE		(0x554)
#define EXYNOS_PA_DBG_RW_MNT_STATE		(0x558)
#define EXYNOS_PA_DBG_RW_PLU_STATE		(0x55C)
#define EXYNOS_PA_DBG_RW_ROE_STATE		(0x560)
#define EXYNOS_PA_DBG_RW_TEST_STATE		(0x564)
#define EXYNOS_PA_DBG_RW_TX_STATE		(0x568)
#define EXYNOS_PA_DBG_PA_BREAK_POINT_ENABLE	(0x56C)
#define EXYNOS_PA_DBG_PA_BREAK_POINT_STATUS	(0x570)
#define EXYNOS_PA_PA_DBG_RX_LATCH_MODE		(0x574)

/* LLI Control Attributes */
#define EXYNOS_DME_LL_INIT_PRESENT		(0x800)
#define EXYNOS_DME_LL_TARG_PRESENT		(0x804)
#define EXYNOS_DME_BE_INIT_PRESENT		(0x808)
#define EXYNOS_DME_BE_TARG_PRESENT		(0x80C)
#define EXYNOS_DME_SVC_TARG_PRESENT		(0x810)
#define EXYNOS_DME_LL_TC_DISABLE		(0x900)
#define EXYNOS_DME_BE_TC_DISABLE		(0x904)
#define EXYNOS_DME_CSA_SYSTEM_STATUS		(0x908)
#define EXYNOS_DME_CSA_SYSTEM_SET		(0x90C)
#define EXYNOS_DME_CSA_SYSTEM_CLR		(0x910)
#define EXYNOS_DME_TL_ADDRESS_MODE		(0x914)

/* DME User Configuration Attributes */
#define EXYNOS_DME_LLI_INFO			(0x1000)
#define EXYNOS_DME_LLI_RESET			(0x1004)
#define EXYNOS_DME_LLI_ROE_REQ			(0x1008)
#define EXYNOS_DME_LLI_INTR_ENABLE		(0x100C)
#define EXYNOS_DME_LLI_INTR_STATUS		(0x1010)
#define EXYNOS_DME_LLI_TL_INTR_REASON		(0x1018)
#define EXYNOS_DME_LLI_DL_INTR_REASON		(0x101C)
#define EXYNOS_DME_LLI_PA_INTR_REASON		(0x1020)
#define EXYNOS_DME_LLI_IAL_INTR_REASON0		(0x1024)
#define EXYNOS_DME_LLI_IAL_INTR_REASON1		(0x1028)

/* DME User Debug Attributes */
#define EXYNOS_DME_DBG_DME_STATE		(0x1090)
#define EXYNOS_DME_DBG_DME_AUTO_RESET		(0x1094)

/* IAL User config Attributes */
#define EXYNOS_IAL_LL_SNF_FIFO			(0x1100)
#define EXYNOS_IAL_BE_SNF_FIFO			(0x1104)
#define EXYNOS_IAL_LL_TARG_ADDR_REMAP		(0x1108)
#define EXYNOS_IAL_BE_TARG_ADDR_REMAP		(0x110C)
#define EXYNOS_IAL_LL_INIT_ADDR_REMAP		(0x1110)
#define EXYNOS_IAL_BE_INIT_ADDR_REMAP		(0x1114)
#define EXYNOS_IAL_LL_CMD_P_DEBUG		(0x1118)
#define EXYNOS_IAL_BE_CMD_P_DEBUG		(0x111C)
#define EXYNOS_IAL_LL_ORDID_BITS_SEL		(0x1120)
#define EXYNOS_IAL_BE_ORDID_BITS_SEL		(0x1124)
#define EXYNOS_IAL_TRAN_RTT_EN			(0x1128)
#define EXYNOS_IAL_LL_TRAN_RTT_CNT		(0x112C)
#define EXYNOS_IAL_BE_TRAN_RTT_CNT		(0x1130)
#define EXYNOS_IAL_SVC_LOC_TRAN_RTT_CNT		(0x1134)
#define EXYNOS_IAL_SVC_REM_TRAN_RTT_CNT		(0x1138)
#define EXYNOS_IAL_LL_TRAN_CMD_REQ_CNT		(0x113C)
#define EXYNOS_IAL_BE_TRAN_CMD_REQ_CNT		(0x1140)
#define EXYNOS_IAL_OVERLAP_ADDR_CTRL_EN		(0x1144)

/* DL User Config Attributes */
#define EXYNOS_DL_CREDIT_THRESHOLD		(0x1200)

/* DL User Debug Attributes */
#define EXYNOS_DL_DBG_TX_CREDTIS		(0x1290)
#define EXYNOS_DL_DBG_RX_BUFFER_SIZES		(0x1294)
#define EXYNOS_DL_DBG_RX_BUFFER_VACANCIES	(0x1298)
#define EXYNOS_DL_DBG_RX_RESIDUAL_CREDITS	(0x129C)
#define EXYNOS_DL_DBG_SIGNAL_STATUS		(0x12A0)

/* TL Signaling Configuration Attributes */
#define EXYNOS_TL_SIGNAL_REG_NUM		(0x2000)
#define EXYNOS_TL_SIGNAL_STATUS_LSB		(0x2004)
#define EXYNOS_TL_SIGNAL_SET_LSB		(0x2008)
#define EXYNOS_TL_SIGNAL_CLR_LSB		(0x200C)
#define EXYNOS_TL_SIGNAL_STATUS_MSB		(0x2010)
#define EXYNOS_TL_SIGNAL_SET_MSB		(0x2014)
#define EXYNOS_TL_SIGNAL_CLR_MSB		(0x2018)

/* TL Debug Signaling Configuration Attributes */
#define EXYNOS_TL_DBG_SIGNAL_REG_NUM		(0x2800)
#define EXYNOS_TL_DBG_SIGNAL_STATUS_LSB		(0x2804)
#define EXYNOS_TL_DBG_SIGNAL_SET_LSB		(0x2808)
#define EXYNOS_TL_DBG_SIGNAL_CLR_LSB		(0x280C)
#define EXYNOS_TL_DBG_SIGNAL_STATUS_MSB		(0x2810)
#define EXYNOS_TL_DBG_SIGNAL_SET_MSB		(0x2814)
#define EXYNOS_TL_DBG_SIGNAL_CLR_MSB		(0x2818)

/* LLI DDB Attributes */
#define EXYNOS_DDB_REVISION			(0x3C00)
#define EXYNOS_DDB_LEVEL			(0x3C04)
#define EXYNOS_DDB_DEVICE_CLASS			(0x3C08)
#define EXYNOS_DDB_MANUFACTURER_ID		(0x3C0C)
#define EXYNOS_DDB_PRODUCT_ID			(0x3C10)
#define EXYNOS_DDB_LENGTH			(0x3C14)

/* Bit fields */

/* Global Configuration Register */
#define INTR_TEST_MODE_EXIT			(1 << 17)
#define INTR_TEST_MODE_ENTER			(1 << 16)
#define INTR_SW_RESET_DONE			(1 << 15)
#define INTR_MOUNT_FAIL				(1 << 14)
#define INTR_RESET_ON_ERROR_SENT		(1 << 13)
#define INTR_IAL_ERROR_INDICATION		(1 << 12)
#define INTR_TL_ERROR_INDICATION		(1 << 11)
#define INTR_DL_ERROR_INDICATION		(1 << 10)
#define INTR_PA_ERROR_INDICATION		(1 << 9)
#define INTR_PA_PLU_DONE			(1 << 8)
#define INTR_PA_PLU_DETECTED			(1 << 7)
#define INTR_MPHY_HIBERN8_EXIT_DONE		(1 << 6)
#define INTR_MPHY_HIBERN8_ENTER_DONE		(1 << 5)
#define INTR_LINK_UPDATE_CONFIG_DONE		(1 << 4)
#define INTR_RESET_ON_ERROR_CLEARED_BY_HW	(1 << 3)
#define INTR_RESET_ON_ERROR_DETECTED		(1 << 2)
#define INTR_LLI_UNMOUNT_DONE			(1 << 1)
#define INTR_LLI_MOUNT_DONE			(1 << 0)

#define RESET_ON_ERROR_DETECTED			(1 << 3)
#define LLI_MOUNT_CTRL				(1 << 2)
#define MASTER_NOT_SLAVE			(1 << 1)
#define LLI_MOUNTED				(1 << 0)

#define LLI_REMAP_BASE_ADDR_SHIFT		(8)
#define LLI_REMAP_ENABLE			(1 << 7)

#define CSA_AUTO_MODE				(1 << 0)
#define CSA_LINKUPDATECONFIG			(1 << 1)
#define CSA_TESTMODE				(1 << 2)
#define CSA_PA_HIBERNATE			(1 << 3)
#define CSA_PA_PLU_RECEIVED			(1 << 4)

#endif /* __DRIVERS_EXYNOS_MIPI_LLI_H */
