/* blink.c
 *
 * ODROID-U3 IO Shield example using sysfs interface.
 * 
 * This file blinks GPIO 289 (TCA6416A P00) while reading GPIO 297 (TCA6416A P10).
 */

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define IN  0
#define OUT 1

#define LOW  0
#define HIGH 1

#define POUT 289 /* TCA6416A P00 */
#define PIN  297 /* TCA6416A P10 */

static void GPIOsys_init(void)
{
	char cmd[100];
	
	/* ODROID-U3 ext-GPIO module probe (TCA6416) need to superuser permission*/
	system("sudo modprobe gpio-pca953x");
	system("sudo su -c 'echo tca6416 0x20 > /sys/devices/platform/i2c-gpio.4/i2c-4/new_device'");

	/* Enable GPIO pins */
	memset(cmd, 0x00, sizeof(cmd));
	sprintf(cmd,"echo %d > /sys/class/gpio/export",POUT);
	system(cmd);
	memset(cmd, 0x00, sizeof(cmd));
	sprintf(cmd,"echo %d > /sys/class/gpio/export",PIN);
	system(cmd);
}

static void GPIOsys_deinit(void)
{
	char cmd[100];

	/* Disable GPIO pins */
	memset(cmd, 0x00, sizeof(cmd));
	sprintf(cmd,"echo %d > /sys/class/gpio/unexport",POUT);
	system(cmd);
	memset(cmd, 0x00, sizeof(cmd));
	sprintf(cmd,"echo %d > /sys/class/gpio/unexport",PIN);
	system(cmd);
	
	/* remove ext-GPIO module (TCA6416) need to superuser permission*/
	system("sudo su -c 'echo 0x20 > /sys/devices/platform/i2c-gpio.4/i2c-4/delete_device'");
	system("sudo modprobe -r gpio-pca953x");
}

static int GPIODirection(int gpio, int dir)
{
	static const char s_directions_str[]  = "in\0out";

#define DIRECTION_MAX 45
	char path[DIRECTION_MAX];
	int fd;

	sprintf(path, "/sys/class/gpio/gpio%d/direction", gpio);
	fd = open(path, O_WRONLY);
	if (-1 == fd) {
		fprintf(stderr, "Failed to open gpio direction for writing!\n");
		return(-1);
	}

	if (-1 == write(fd, &s_directions_str[IN == dir ? 0 : 3], IN == dir ? 2 : 3)) {
		fprintf(stderr, "Failed to set direction! %d \n",gpio);
		return(-1);
	}

	close(fd);
	return(0);
}

static int GPIORead(int gpio)
{
#define VALUE_MAX 30
	char path[VALUE_MAX];
	char value_str[3];
	int fd;

	snprintf(path, VALUE_MAX, "/sys/class/gpio/gpio%d/value", gpio);
	fd = open(path, O_RDONLY);
	if (-1 == fd) {
		fprintf(stderr, "Failed to open gpio value for reading!\n");
		return(-1);
	}

	if (-1 == read(fd, value_str, 3)) {
		fprintf(stderr, "Failed to read value!\n");
		return(-1);
	}

	close(fd);

	return(atoi(value_str));
}

static int GPIOWrite(int gpio, int value)
{
	static const char s_values_str[] = "01";

	char path[VALUE_MAX];
	int fd;

	snprintf(path, VALUE_MAX, "/sys/class/gpio/gpio%d/value", gpio);
	fd = open(path, O_WRONLY);
	if (-1 == fd) {
		fprintf(stderr, "Failed to open gpio value for writing!\n");
		return(-1);
	}

	if (1 != write(fd, &s_values_str[LOW == value ? 0 : 1], 1)) {
		fprintf(stderr, "Failed to write value!\n");
		return(-1);
	}

	close(fd);
	return(0);
}

int main(int argc, char *argv[])
{
	int repeat = 20;

	/* GPIO module init*/
	GPIOsys_init();

	/* Set GPIO directions */
	if (-1 == GPIODirection(POUT, OUT) || -1 == GPIODirection(PIN, IN))
		return(2);

	do {
		/* Write GPIO value */
		if (-1 == GPIOWrite(POUT, repeat % 2))
			return(3);

		/* Read GPIO value */
		printf("GPIO %d read value = %d\n", PIN, GPIORead(PIN));
		usleep(500 * 1000);
	}
	while (repeat--);

	/* GPIO module deinit*/
	GPIOsys_deinit();

	return(0);
}
