#!/bin/sh
#
# Hakjoo kim <ruppi.kim@hardkernel.com> Hardkernel Co.,Ltd.
#

whereiam=$(cd $(dirname $0) && pwd)

fstab=${whereiam}/fstab
flash_kernel=${whereiam}/flash-kernel
MODEL=`echo $(grep "Hardware" /proc/cpuinfo) | cut -d ' ' -f3`
model=`echo $MODEL | tr A-Z a-z`
deb_name=`echo $(ls -l linux-image-*.deb) | cut -d ' ' -f9`
deb_addver=`echo ${deb_name} | cut -d '-' -f3`
deb_appendver=`echo ${deb_name} | cut -d '-' -f4 | cut -d '_' -f1` 

modify_lsb_release()
{
	sed -i '1s/Linaro/Ubuntu/g' /etc/lsb-release
}

install_rt5370()
{
	echo "Install Ralink's rt5370 USB WiFi Dongle driver"
cat > /etc/modprobe.d/blacklist-ralink.conf << "EOF"
blacklist rt2x00usb 
blacklist rt2x00lib
blacklist rt2800usb 
blacklist rt2800lib 
EOF
	if [ ! -f /lib/firmware/rt2870.bin ]; then
		cp rt2870.bin /lib/firmware/
	fi

	if [ ! -f /etc/Wireless/RT2870STA/RT2870STA.dat ]; then
		mkdir -p /etc/Wireless/RT2870STA
		cp RT2870STA.dat /etc/Wireless/RT2870STA/
	fi	

	if [ ! -f /lib/modules/$deb_addver-$deb_appendver/kernel/drivers/net/wireless/rt5370sta.ko ]; then
		cp rt5370sta.ko /lib/modules/$deb_addver-$deb_appendver/kernel/drivers/net/wireless/
	fi
}

install_linux_image()
{
	if [ -f /var/lib/initramfs-tools/3.7.0-rc5 ]; then
		echo "remove dirty files"
		rm -fv /var/lib/initramfs-tools/*
	fi
	if [ -f $fstab ]; then
		cp -v $fstab /etc/fstab
	fi
	if [ -f $flash_kernel ]; then
		cp -v $flash_kernel /usr/sbin/flash-kernel
	fi
	echo "Installing linux image and linux headers debian package"
	dpkg -i *${model}*.deb
	
	flash-kernel $deb_addver-$deb_appendver
	echo "Installation completed. Please sync && reboot"
}

echo "Hardkenrel's linux kernel installer for $deb_appendver"
echo -n "Continue ? [n] "
read yesno
if [ "$yesno" = "Y" ] || [ "$yesno" = "y" ]; then
	install_linux_image
	modify_lsb_release
	install_rt5370
else
	echo "You not do install linux image!"
	exit 0
fi
